/*
 * Decompiled with CFR 0.152.
 */
package com.fnkee.flimsytorches.config;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigWriter {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec.IntValue FLIMSY_BURN_AGE;
    public static final ForgeConfigSpec.IntValue USED_BURN_AGE;
    public static final ForgeConfigSpec.IntValue SMOLDERING_BURN_AGE;
    public static final ForgeConfigSpec.DoubleValue CHANCE_LUCKY_TORCH;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> OTHER_GROUND_TORCHES;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> OTHER_WALL_TORCHES;
    public static final ForgeConfigSpec.IntValue VILLAGER_REPLACE_INTERVAL;
    public static final ForgeConfigSpec.BooleanValue ALLOW_BURNT_OUT_REPLACEMENT;
    public static final ForgeConfigSpec.BooleanValue ALLOW_SMOLDERING_REPLACEMENT;
    public static final ForgeConfigSpec.BooleanValue ALLOW_USED_REPLACEMENT;
    public static final ForgeConfigSpec CONFIG;

    static {
        BUILDER.comment("Torch Burn Duration");
        BUILDER.push("torch_duration");
        BUILDER.comment("Age required before torch degrades. A value of 5 lasts approximately 17 minutes on average.");
        FLIMSY_BURN_AGE = BUILDER.comment("Flimsy Torch Age (Default: 5)").defineInRange("flimsyTorchAge", 5, 0, 15);
        USED_BURN_AGE = BUILDER.comment("Used Torch Age (Default: 5)").defineInRange("usedTorchAge", 5, 0, 15);
        SMOLDERING_BURN_AGE = BUILDER.comment("Smoldering Torch Age (Default: 5)").defineInRange("smolderingTorchAge", 5, 0, 15);
        BUILDER.comment("Other Torches");
        BUILDER.pop();
        BUILDER.push("other_torches");
        BUILDER.comment("List of torches from other mods to be replaced by flimsy torches if generated.");
        OTHER_GROUND_TORCHES = BUILDER.comment("Ground torches to be replaced").defineListAllowEmpty("otherGroundTorches", List.of("othermod:other_torch", "anothermod:another_torch"), obj -> obj instanceof String);
        OTHER_WALL_TORCHES = BUILDER.comment("Wall torches to be replaced").defineListAllowEmpty("otherWallTorches", List.of("othermod:other_wall_torch", "anothermod:another_wall_torch"), obj -> obj instanceof String);
        BUILDER.comment("General Settings");
        BUILDER.pop();
        BUILDER.push("general");
        CHANCE_LUCKY_TORCH = BUILDER.comment("Chance of a generated torch to remain a regular, non-flimsy torch (Default: 0.01 - 1%)").defineInRange("chanceLuckyTorch", 0.01, 0.0, 1.0);
        BUILDER.comment("Villager Torch Behavior");
        BUILDER.pop();
        BUILDER.push("villager_torch_behavior");
        BUILDER.comment("Interval between each attempt to replace a torch. A value of 20 equals 1 second.");
        VILLAGER_REPLACE_INTERVAL = BUILDER.comment("Torch Replace Interval. (Default: 100)").defineInRange("torchReplaceInterval", 100, 1, Integer.MAX_VALUE);
        BUILDER.comment("Defines which torch types villagers are allowed to replace. Lower condition torches are prioritized first.");
        ALLOW_BURNT_OUT_REPLACEMENT = BUILDER.comment("Allow villagers to replace Burnt Out torches").define("allowBurntOutReplacement", true);
        ALLOW_SMOLDERING_REPLACEMENT = BUILDER.comment("Allow villagers to replace Smoldering Torches").define("allowSmolderingReplacement", true);
        ALLOW_USED_REPLACEMENT = BUILDER.comment("Allow villagers to replace Used Torches").define("allowUsedReplacement", false);
        BUILDER.pop();
        CONFIG = BUILDER.build();
    }
}

