/*
 * Decompiled with CFR 0.152.
 */
package com.fnkee.flimsytorches.events;

import com.fnkee.flimsytorches.config.ConfigWriter;
import com.fnkee.flimsytorches.events.FlimsyTorchChunkData;
import com.fnkee.flimsytorches.setup.ModBlocks;
import com.fnkee.flimsytorches.util.handlers.ExternalTorchRegistryHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ChunkEvents {
    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        Level world = (Level)event.getLevel();
        LevelChunk chunk = (LevelChunk)event.getChunk();
        ChunkPos chunkPos = chunk.m_7697_();
        FlimsyTorchChunkData data = FlimsyTorchChunkData.get(world);
        if (data == null || data.isProcessed(chunkPos)) {
            return;
        }
        if (world.m_5776_()) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 1; y < 256; ++y) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block currentBlock = chunk.m_8055_(pos).m_60734_();
                    if (currentBlock == Blocks.f_50081_ || ExternalTorchRegistryHandler.otherTorchBlocks.contains(currentBlock)) {
                        if (!((double)world.m_213780_().m_188501_() > (Double)ConfigWriter.CHANCE_LUCKY_TORCH.get())) continue;
                        chunk.m_6978_(pos, ((Block)ModBlocks.FLIMSY_TORCH.get()).m_49966_(), false);
                        continue;
                    }
                    if (currentBlock != Blocks.f_50082_ && !ExternalTorchRegistryHandler.otherWallTorchBlocks.contains(currentBlock) || !((double)world.m_213780_().m_188501_() > (Double)ConfigWriter.CHANCE_LUCKY_TORCH.get())) continue;
                    BlockState originalState = chunk.m_8055_(pos);
                    Direction facing = (Direction)originalState.m_61143_((Property)BlockStateProperties.f_61374_);
                    BlockState newState = (BlockState)((Block)ModBlocks.FLIMSY_WALL_TORCH.get()).m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)facing);
                    chunk.m_6978_(pos, newState, false);
                }
            }
        }
        if (data != null) {
            data.markProcessed(chunkPos);
        }
    }
}

