/*
 * Decompiled with CFR 0.152.
 */
package com.fnkee.flimsytorches.events;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class FlimsyTorchChunkData
extends SavedData {
    public static final String ID = "flimsy_torch_chunks";
    private final Set<Long> processedChunks = new HashSet<Long>();

    public FlimsyTorchChunkData() {
    }

    public FlimsyTorchChunkData(CompoundTag compound) {
        ListTag list = compound.m_128437_("chunks", 10);
        for (Tag tag : list) {
            CompoundTag data = (CompoundTag)tag;
            long chunkPos = data.m_128454_("chunkPos");
            this.processedChunks.add(chunkPos);
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag list = new ListTag();
        for (Long chunkPos : this.processedChunks) {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("chunkPos", chunkPos.longValue());
            list.add((Object)tag);
        }
        compound.m_128365_("chunks", (Tag)list);
        return compound;
    }

    public boolean isProcessed(ChunkPos pos) {
        return this.processedChunks.contains(pos.m_45588_());
    }

    public void markProcessed(ChunkPos pos) {
        this.processedChunks.add(pos.m_45588_());
        this.m_77762_();
    }

    public static FlimsyTorchChunkData get(Level level) {
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            return (FlimsyTorchChunkData)sl.m_8895_().m_164861_(FlimsyTorchChunkData::new, FlimsyTorchChunkData::new, ID);
        }
        return null;
    }
}

