/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.networking;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import net.tslat.tes.core.particle.TESParticleManager;
import org.jetbrains.annotations.Nullable;

public class ParticleClaimPacket {
    private final int entityId;
    private final ResourceLocation claimantId;
    @Nullable
    private final CompoundTag data;

    public ParticleClaimPacket(int entityId, ResourceLocation claimantId, @Nullable CompoundTag data) {
        this.entityId = entityId;
        this.claimantId = claimantId;
        this.data = data;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130130_(this.entityId);
        buf.m_130085_(this.claimantId);
        buf.m_130079_(this.data);
    }

    public static ParticleClaimPacket decode(FriendlyByteBuf buf) {
        return new ParticleClaimPacket(buf.m_130242_(), buf.m_130281_(), buf.m_130260_());
    }

    public void handleMessage(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> TESParticleManager.addParticleClaim(this.entityId, this.claimantId, this.data));
        context.get().setPacketHandled(true);
    }
}

