/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.tes.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraftforge.common.Tags;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import net.tslat.tes.api.TESEntityType;
import org.jetbrains.annotations.Nullable;

public class TESUtil
implements net.tslat.tes.api.util.TESUtil {
    private final Map<Class<? extends LivingEntity>, TESEntityType> entityTypeMap = new Object2ObjectOpenHashMap();

    @Override
    @Nullable
    public LivingEntity getLivingEntityIfPossible(@Nullable Entity entity) {
        PartEntity partEntity;
        Entity entity2;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity instanceof ArmorStand) {
                return null;
            }
            return livingEntity;
        }
        if (entity instanceof PartEntity && (entity2 = (partEntity = (PartEntity)entity).getParent()) instanceof LivingEntity) {
            LivingEntity parent = (LivingEntity)entity2;
            return parent;
        }
        return null;
    }

    @Override
    public TESEntityType getEntityType(LivingEntity entity) {
        return this.entityTypeMap.computeIfAbsent(entity.getClass(), clazz -> {
            if (entity.m_6095_() == EntityType.f_20532_) {
                return TESEntityType.PLAYER;
            }
            if (ForgeRegistries.ENTITY_TYPES.tags().getTag(Tags.EntityTypes.BOSSES).contains((Object)entity.m_6095_())) {
                return TESEntityType.BOSS;
            }
            if (entity instanceof Enemy) {
                return TESEntityType.HOSTILE;
            }
            if (entity instanceof NeutralMob) {
                return TESEntityType.NEUTRAL;
            }
            return TESEntityType.PASSIVE;
        });
    }

    @Override
    public final void clearDynamicCaches() {
        this.entityTypeMap.entrySet().removeIf(classTESEntityTypeEntry -> classTESEntityTypeEntry.getValue() == TESEntityType.BOSS);
    }
}

