/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.events;

import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.keybinds.KeyAction;
import dlovin.inventoryhud.keybinds.KeyBinds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;

public class ClientEvents {
    private final Minecraft mc = Minecraft.getInstance();
    private Inventory pInv;
    private int tc = -1;

    public ClientEvents() {
        InputEvent.Key.BUS.addListener(this::onKeyInput);
        InputEvent.MouseButton.Pre.BUS.addListener(this::onMouseInput);
        ClientPlayerNetworkEvent.LoggingIn.BUS.addListener(this::onEnter);
        TickEvent.PlayerTickEvent.Post.BUS.addListener(this::onInventory);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (this.mc.screen != null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        for (KeyAction keyAction : KeyBinds.keyActionList) {
            if (!keyAction.keyDown(new KeyEvent(event.getKey(), event.getScanCode(), event.getModifiers()))) continue;
            return;
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton.Pre event) {
        if (this.mc.screen != null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        for (KeyAction keyAction : KeyBinds.keyActionList) {
            if (!keyAction.mouseDown(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(event.getButton(), event.getModifiers())))) continue;
            return;
        }
    }

    @SubscribeEvent
    public void onEnter(ClientPlayerNetworkEvent.LoggingIn event) {
        this.pInv = null;
    }

    @SubscribeEvent
    public void onInventory(TickEvent.PlayerTickEvent.Post event) {
        if (!InventoryGui.animated) {
            return;
        }
        if (!event.player().equals((Object)Minecraft.getInstance().player) || event.side().equals((Object)LogicalSide.SERVER)) {
            return;
        }
        if (this.pInv == null) {
            this.pInv = new Inventory(event.player(), new EntityEquipment());
            this.pInv.replaceWith(event.player().getInventory());
            this.tc = -1;
            return;
        }
        if (event.player().getInventory().getTimesChanged() != this.tc) {
            this.tc = event.player().getInventory().getTimesChanged();
            for (int i = 9; i < 36; ++i) {
                ItemStack cItem = event.player().getInventory().getItem(i);
                ItemStack pItem = this.pInv.getItem(i);
                if ((!cItem.getItem().equals(pItem.getItem()) || cItem.getCount() <= pItem.getCount()) && (cItem.getItem().equals(Items.AIR) || !pItem.getItem().equals(Items.AIR))) continue;
                event.player().getInventory().getItem(i).setPopTime(5);
            }
            this.pInv.replaceWith(event.player().getInventory());
        }
    }
}

