/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.config;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.config.PotionConfigScreen;
import dlovin.inventoryhud.gui.config.ScreenWithOptionList;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.CustomButton;
import dlovin.inventoryhud.gui.widgets.CustomOptionList;
import dlovin.inventoryhud.gui.widgets.IconWidget;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.references.Translation;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.NotNull;

public class EffectsBlackListScreen
extends ScreenWithOptionList {
    private final boolean inGame;
    private CustomButton saveBtn;

    public EffectsBlackListScreen(boolean inGame) {
        super(Translation.BLACKLIST_TITLE);
        this.inGame = inGame;
    }

    protected void init() {
        this.optionList = new CustomOptionList(this.minecraft, this, 32);
        this.addControlLine();
        List effectList = (List)InventoryHUD.getClientConfig().effectsBlacklist.get();
        for (int i = 0; i < effectList.size(); ++i) {
            this.addLine(i, (String)effectList.get(i));
        }
        this.addRenderableWidget((GuiEventListener)this.optionList);
    }

    private void addLine(int i, String effect) {
        IconWidget effectIcon = new IconWidget(this.width / 2 + 105, 0, 20, 20, effect);
        this.optionList.insertWidget(effectIcon, i);
        this.optionList.addWidget(new TextField(this.font, this.width / 2 - 100, 0, 200, 20, effect, w -> {
            effectIcon.setEffectAtlasSprite(w.getText());
            this.saveBtn.setMessage(String.valueOf(ChatFormatting.RED) + Translation.SAVE.getString());
        }, "[a-z0-9._-]*[/:]?[a-z0-9._-]*"), i);
        int deleteBtnSize = this.font.width(Translation.DELETE.getString()) + 8;
        CustomButton deleteBtn = new CustomButton(this.width / 2 - deleteBtnSize - 105, 0, deleteBtnSize, 20, Translation.DELETE.getString(), null, false);
        this.optionList.addWidget(deleteBtn, i);
        deleteBtn.addListener(btn -> {
            this.optionList.removeRowWith(deleteBtn);
            this.saveBtn.setMessage(String.valueOf(ChatFormatting.RED) + Translation.SAVE.getString());
        });
    }

    private void addControlLine() {
        int saveBtnSize = this.font.width(Translation.SAVE.getString()) + 8;
        int addBtnSize = this.font.width(Translation.ADD.getString()) + 8;
        this.saveBtn = new CustomButton(this.width / 2 - saveBtnSize - 5, 0, saveBtnSize, 20, String.valueOf(ChatFormatting.GREEN) + Translation.SAVE.getString(), null, false);
        this.optionList.addWidget(this.saveBtn, 0);
        this.saveBtn.addListener(this::saveEffects);
        CustomButton nextButton = new CustomButton(this.width / 2 + 5, 0, addBtnSize, 20, Translation.ADD.getString(), null, false);
        this.optionList.addWidget(nextButton, 0);
        nextButton.addListener(this::addEffect);
    }

    private void saveEffects(ButtonWidget btn) {
        List<String> effects = this.optionList.getWidgets().stream().filter(w -> w instanceof TextField).map(w -> ((TextField)w).getText()).toList();
        InventoryHUD.getClientConfig().effectsBlacklist.set(effects);
        InventoryHUD.saveConfig();
        InventoryHUD.getInstance().getInventoryGui().resetBlackList();
        this.saveBtn.setMessage(String.valueOf(ChatFormatting.GREEN) + Translation.SAVE.getString());
    }

    private void addEffect(ButtonWidget btn) {
        this.addLine(this.optionList.rowsCount() - 1, "");
        this.saveBtn.setMessage(String.valueOf(ChatFormatting.RED) + Translation.SAVE.getString());
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float partialTick) {
        gui.fillGradient(0, 0, gui.guiWidth(), 32, -587202560, -2013265920);
        this.optionList.render(gui, mouseX, mouseY, partialTick);
        this.renderTitle(gui);
        this.optionList.renderTooltips(gui, mouseX, mouseY);
    }

    public void renderTitle(@NotNull GuiGraphics gui) {
        gui.pose().pushMatrix();
        gui.pose().translate((float)this.width * 0.5f, 10.0f);
        gui.pose().pushMatrix();
        gui.pose().scale(2.0f, 2.0f);
        gui.drawCenteredString(this.font, this.title.getString(), 0, 0, -1);
        gui.pose().popMatrix();
        gui.pose().popMatrix();
    }

    public void onClose() {
        if (this.minecraft == null) {
            return;
        }
        this.minecraft.setScreen((Screen)new PotionConfigScreen(this.inGame));
    }
}

