/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud;

import dlovin.inventoryhud.InventoryHudConfigHandler;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.events.ClientEvents;
import dlovin.inventoryhud.events.RegistryEvents;
import dlovin.inventoryhud.events.UpdateNotificationEvent;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.gui.overlays.ArmorOverlay;
import dlovin.inventoryhud.gui.overlays.IHudOverlay;
import dlovin.inventoryhud.gui.overlays.InventoryOverlay;
import dlovin.inventoryhud.gui.overlays.PotionOverlay;
import dlovin.inventoryhud.keybinds.KeyBinds;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventoryhud")
public class InventoryHUD {
    public static InventoryHUD instance;
    public static final String modid = "inventoryhud";
    public static String version;
    private static final Logger logger;
    public static boolean isActive;
    public static boolean armorHUD;
    public static boolean potionHUD;
    private InventoryGui inventoryGui;
    private List<IHudOverlay> overlays;

    public InventoryHUD(IEventBus modEventBus, ModContainer modContainer) {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        version = modContainer.getModInfo().getVersion().toString();
        instance = this;
        modEventBus.register((Object)new KeyBinds());
        modEventBus.register((Object)new RegistryEvents());
        modEventBus.addListener(this::clientRegistries);
        InvConfig.register(modContainer);
        InventoryHudConfigHandler.init();
    }

    public static InvConfig.Client getClientConfig() {
        return InvConfig.CONFIG.getClient();
    }

    public static void saveConfig() {
        InvConfig.CONFIG.clientSpec.save();
    }

    public InventoryGui getInventoryGui() {
        return this.inventoryGui;
    }

    public static InventoryHUD getInstance() {
        return instance;
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientEvents());
        NeoForge.EVENT_BUS.register((Object)new UpdateNotificationEvent());
    }

    public List<IHudOverlay> initOverlays() {
        this.inventoryGui = new InventoryGui();
        this.overlays = new ArrayList<IHudOverlay>();
        this.overlays.add(new InventoryOverlay("inventory"));
        this.overlays.add(new ArmorOverlay("armor"));
        this.overlays.add(new PotionOverlay("potion"));
        this.overlays.forEach(IHudOverlay::init);
        return this.overlays;
    }

    public static void log(String message) {
        logger.info(message);
    }

    static {
        logger = LogManager.getLogger((String)modid);
        isActive = false;
        armorHUD = false;
        potionHUD = true;
    }
}

