/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import dlovin.inventoryhud.gui.widgets.RowOfWidgets;
import dlovin.inventoryhud.gui.widgets.TextField;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.utils.RenderHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;

public class CustomOptionList
extends AbstractSelectionList {
    private static final int ITEM_HEIGHT = 30;
    private final List<RowOfWidgets> rows = new ArrayList<RowOfWidgets>();
    private int maxHeight;
    private int scroll = 0;
    private double tmp_scroll = 0.0;
    private boolean isDragging = false;
    private final ResourceLocation SCROLL = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/scroll.png");

    public CustomOptionList(Minecraft minecraft, Screen screen) {
        this(minecraft, screen, 55);
    }

    public CustomOptionList(Minecraft minecraft, Screen screen, int top) {
        super(minecraft, screen.width, screen.height - top, top, 30);
    }

    public void addWidget(Widget widget, int row) {
        if (this.maxHeight < (row + 1) * 30 + 10) {
            this.maxHeight = (row + 1) * 30 + 10;
        }
        widget.y = this.getY() + 10 + 30 * row + widget.y - this.scroll;
        if (this.rows.stream().anyMatch(r -> r.index == row)) {
            this.rows.stream().filter(r -> r.index == row).findFirst().get().addWidget(widget);
        } else {
            this.rows.add(new RowOfWidgets(row, widget));
        }
    }

    public void insertWidget(Widget widget, int row) {
        int lastRowIndex = 0;
        for (RowOfWidgets r2 : this.rows) {
            if (r2.index <= lastRowIndex) continue;
            lastRowIndex = r2.index;
        }
        this.maxHeight = (lastRowIndex + 2) * 30 + 10;
        widget.y = this.getY() + 10 + 30 * row + widget.y - this.scroll;
        this.rows.stream().filter(r -> r.index >= row).forEach(r -> {
            ++r.index;
            for (Widget w : r.widgetList) {
                w.y += 30;
            }
        });
        this.rows.add(new RowOfWidgets(row, widget));
    }

    public void removeRowWith(Widget widget) {
        int index = 0;
        for (RowOfWidgets row : this.rows) {
            if (!row.widgetList.contains(widget)) continue;
            index = row.index;
            break;
        }
        this.removeRow(index);
    }

    public void removeRow(int index) {
        boolean removed = false;
        Iterator<RowOfWidgets> iterator = this.rows.iterator();
        while (iterator.hasNext()) {
            RowOfWidgets item = iterator.next();
            if (item.index != index) continue;
            iterator.remove();
            removed = true;
            break;
        }
        if (!removed) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            if (row.index <= index) continue;
            --row.index;
            for (Widget w : row.widgetList) {
                w.y -= 30;
            }
        }
        this.maxHeight -= 30;
        int diff = this.maxHeight - (this.getBottom() - this.getY());
        if (diff < 0) {
            double tmp = this.scroll;
            this.scroll = 0;
            this.adjustWidgetsPos(tmp);
        } else {
            this.mouseScrolled(0.0, 0.0, 0.0, 0.0);
        }
    }

    public List<Widget> getWidgets() {
        ArrayList<Widget> tmp = new ArrayList<Widget>();
        for (RowOfWidgets row : this.rows) {
            tmp.addAll(row.widgetList);
        }
        return tmp;
    }

    public int rowsCount() {
        return this.rows.size();
    }

    private double scroll(double amount) {
        double tmp = (int)(amount * 5.0);
        int diff = this.maxHeight - (this.getBottom() - this.getY());
        this.scroll = (int)((double)this.scroll - tmp);
        if (this.scroll < 0) {
            tmp += (double)this.scroll;
            this.scroll = 0;
        } else if (this.scroll > diff) {
            tmp += (double)(this.scroll - diff);
            this.scroll = diff;
        }
        return tmp;
    }

    private void adjustWidgetsPos(double amount) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (w instanceof TextField && ((TextField)w).isFocused()) {
                    ((TextField)w).setFocused2(false);
                }
                w.y = (int)((double)w.y + amount);
            }
        }
    }

    public boolean mouseScrolled(double mx, double my, double scrollX, double scrollY) {
        if (this.maxHeight > this.getBottom() - this.getY()) {
            this.adjustWidgetsPos(this.scroll(scrollY));
        }
        return true;
    }

    public boolean mouseDragged(double mx, double my, int button, double dragX, double dragY) {
        if (this.isDragging) {
            int height = this.getBottom() - this.getY();
            double scale = (double)height / (double)this.maxHeight;
            this.tmp_scroll += dragY / scale;
            int tmp = (int)this.tmp_scroll;
            this.tmp_scroll -= (double)tmp;
            int diff = this.maxHeight - (this.getBottom() - this.getY());
            this.scroll += tmp;
            if (this.scroll < 0) {
                tmp -= this.scroll;
                this.scroll = 0;
            } else if (this.scroll > diff) {
                tmp -= this.scroll - diff;
                this.scroll = diff;
            }
            this.adjustWidgetsPos(-tmp);
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseBtn) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return false;
        }
        if (this.maxHeight > this.getBottom() - this.getY() && mouseBtn == 0) {
            int pos = this.width > 309 ? this.width / 2 + 150 : this.width - 9;
            int height = this.getBottom() - this.getY();
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.getY() + (int)((double)this.scroll * scale);
            if (this.isOver(mouseX, mouseY, pos + 1, pos + 8, yPos + 1, yPos + height - 1)) {
                this.isDragging = true;
            }
        }
        ArrayList<Runnable> clicks = new ArrayList<Runnable>();
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!w.hovered && !(w instanceof TextField)) continue;
                clicks.add(() -> w.mouseClicked(mouseX, mouseY, mouseBtn));
            }
        }
        clicks.forEach(Runnable::run);
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseBtn) {
        this.isDragging = false;
        return false;
    }

    public boolean charTyped(char character, int keyCode) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !w.isFocused()) continue;
                w.charTyped(character, keyCode);
                return true;
            }
        }
        return false;
    }

    public boolean keyPressed(int p_231046_1_, int p_231046_2_, int p_231046_3_) {
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                if (!(w instanceof TextField) || !w.isFocused()) continue;
                w.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
                return true;
            }
        }
        super.keyPressed(p_231046_1_, p_231046_2_, p_231046_3_);
        return false;
    }

    private void renderScrollBG(GuiGraphics gui, int xPos, int height) {
        RenderHelper.drawTextureWithBorder(gui, this.SCROLL, xPos, this.getY(), 9, height, 3, 16, 32);
    }

    private void renderScroll(GuiGraphics gui, int xPos, int height, int pos, int color) {
        RenderHelper.drawTextureWithBorder(gui, this.SCROLL, xPos, pos, 9, Math.max(height, 6), 16, 0, 3, 16, 32, color);
    }

    private boolean isOver(double p_231047_1_, double p_231047_3_, int min_x, int max_x, int min_y, int max_y) {
        return p_231047_3_ >= (double)min_y && p_231047_3_ <= (double)max_y && p_231047_1_ >= (double)min_x && p_231047_1_ <= (double)max_x;
    }

    protected void renderListItems(@NotNull GuiGraphics gui, int mx, int my, float pt) {
        if (this.maxHeight > this.getBottom() - this.getY()) {
            int pos = this.width > 309 ? this.width / 2 + 150 : this.width - 9;
            int height = this.getBottom() - this.getY();
            this.renderScrollBG(gui, pos, height);
            double scale = (double)height / (double)this.maxHeight;
            height = (int)((double)height * scale);
            int yPos = this.getY() + (int)((double)this.scroll * scale);
            int color = ARGB.colorFromFloat((float)1.0f, (float)0.8f, (float)0.8f, (float)0.8f);
            if (this.isOver(mx, my, pos + 1, pos + 8, yPos + 1, yPos + height - 1) && this.isDragging) {
                color = -1;
            }
            this.renderScroll(gui, pos, height, yPos, color);
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.render(gui, mx, my, pt);
            }
        }
    }

    public void renderTooltips(GuiGraphics gui, int x, int y) {
        if (y > this.getBottom() || y < this.getY() || x > this.getWidth() || x < 0) {
            return;
        }
        for (RowOfWidgets row : this.rows) {
            for (Widget w : row.widgetList) {
                w.renderTooltip(gui, x, y);
            }
        }
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

