/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.events;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.InventoryGui;
import dlovin.inventoryhud.keybinds.KeyAction;
import dlovin.inventoryhud.keybinds.KeyBinds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiLayerEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

public class ClientEvents {
    private Inventory pInv;
    private int tc = -1;

    @SubscribeEvent
    public void onLayerRender(RenderGuiLayerEvent.Pre event) {
        if (InventoryHUD.potionHUD && event.getName() == VanillaGuiLayers.EFFECTS) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        for (KeyAction keyAction : KeyBinds.keyActionList) {
            if (!keyAction.keyDown(event.getKey(), event.getScanCode())) continue;
            return;
        }
    }

    @SubscribeEvent
    public void onMouseInput(InputEvent.MouseButton.Post event) {
        if (Minecraft.getInstance().screen != null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        for (KeyAction keyAction : KeyBinds.keyActionList) {
            if (!keyAction.mouseDown(event.getButton())) continue;
            return;
        }
    }

    @SubscribeEvent
    public void onEnter(ClientPlayerNetworkEvent.LoggingIn event) {
        this.pInv = null;
    }

    @SubscribeEvent
    public void onInventory(ClientTickEvent.Post event) {
        if (!InventoryGui.animated) {
            return;
        }
        if (Minecraft.getInstance().player == null) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (this.pInv == null) {
            this.pInv = new Inventory((Player)player, new EntityEquipment());
            this.pInv.replaceWith(player.getInventory());
            this.tc = -1;
            return;
        }
        if (player.getInventory().getTimesChanged() != this.tc) {
            this.tc = player.getInventory().getTimesChanged();
            for (int i = 9; i < 36; ++i) {
                ItemStack cItem = player.getInventory().getItem(i);
                ItemStack pItem = this.pInv.getItem(i);
                if ((!cItem.getItem().equals(pItem.getItem()) || cItem.getCount() <= pItem.getCount()) && (cItem.getItem().equals(Items.AIR) || !pItem.getItem().equals(Items.AIR))) continue;
                player.getInventory().getItem(i).setPopTime(5);
            }
            this.pInv.replaceWith(player.getInventory());
        }
    }
}

