/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;

public class EachArmorRenderer
extends ArmorRenderer {
    public EachArmorRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(GuiGraphics gui, int width, int height) {
        this.preRender(gui, 0, 0);
        this.renderItems(gui, width, height);
        this.postRender(gui);
    }

    private void renderItems(GuiGraphics gui, int width, int height) {
        int seed = 40;
        if (this.showMain) {
            seed = this.renderItem(gui, this.mc.player.getMainHandItem(), width, height, 5, seed);
        }
        if (this.showOff) {
            seed = this.renderItem(gui, this.mc.player.getOffhandItem(), width, height, 4, seed);
        }
        if (this.showArmor) {
            seed = this.renderItem(gui, this.mc.player.getItemBySlot(EquipmentSlot.FEET), width, height, 3, seed);
            seed = this.renderItem(gui, this.mc.player.getItemBySlot(EquipmentSlot.LEGS), width, height, 2, seed);
            seed = this.renderItem(gui, this.mc.player.getItemBySlot(EquipmentSlot.CHEST), width, height, 1, seed);
            this.renderItem(gui, this.mc.player.getItemBySlot(EquipmentSlot.HEAD), width, height, 0, seed);
        }
        if (this.showArrows || this.showInv) {
            int[] values = this.getFreeAndAmmo();
            this.renderHelperSlot(gui, width, height, this.showInv, values[0], 6);
            this.renderHelperSlot(gui, width, height, this.showArrows(), values[1], 7);
        }
    }

    private int renderItem(GuiGraphics gui, ItemStack item, int width, int height, int index, int seed) {
        int x = this.getX(width, (int)(16.0f * this.armScale), this.items[index].x, this.items[index].aligns.HorAlign);
        int y = this.getY(height, (int)(16.0f * this.armScale), this.items[index].y, this.items[index].aligns.VertAlign);
        boolean right = this.getRight(this.items[index].x, this.items[index].aligns.HorAlign);
        int damage = ArmorStatus.getDamage(item);
        if (damage >= 0 && damage <= this.armAbove) {
            String text = this.getText(item, damage);
            this.pushAndRender(gui, x, y, !right, null, item, text, this.armBars, this.armScale, seed++);
        } else if (damage == -2) {
            String t = null;
            boolean over = true;
            if ((index == 5 || index == 4) && this.showCount) {
                t = "" + this.getItemCount(item);
                over = false;
            }
            this.pushAndRender(gui, x, y, !right, null, item, t, over, this.armScale, seed++);
        } else if (this.showEmpty) {
            this.pushAndRender(gui, x, y, !right, this.armorRL[index], null, null, false, this.armScale, 0);
        }
        return seed;
    }

    private void renderHelperSlot(GuiGraphics gui, int width, int height, boolean enabled, int value, int index) {
        if (enabled) {
            int x = this.getX(width, (int)(16.0f * this.armScale), this.items[index].x, this.items[index].aligns.HorAlign);
            int y = this.getY(height, (int)(16.0f * this.armScale), this.items[index].y, this.items[index].aligns.VertAlign);
            boolean right = this.getRight(this.items[index].x, this.items[index].aligns.HorAlign);
            this.pushAndRender(gui, x, y, !right, this.armorRL[index], null, "" + value, false, this.armScale, 0);
        }
    }

    private void pushAndRender(GuiGraphics gui, int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale, int seed) {
        gui.pose().pushPose();
        gui.pose().translate((double)x, (double)y, 0.0);
        gui.pose().scale(scale, scale, 1.0f);
        this.renderElement(gui, right, resourceLocation, itemStack, text, over, seed);
        gui.pose().popPose();
    }
}

