/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.utils.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CheckBox
extends Widget {
    protected final IPressable onChange;
    public boolean checked;
    private final ResourceLocation BG;

    public CheckBox(int x, int y, int width, int height, IPressable onPress, boolean checked, ResourceLocation bg) {
        super(x, y, width, height, "");
        this.onChange = onPress;
        this.checked = checked;
        this.BG = bg;
    }

    @Override
    public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (this.hovered) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            this.checked = !this.checked;
            this.onChange.onChanged(this);
            return true;
        }
        return false;
    }

    public void playDownSound(SoundManager soundManager) {
        soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    @Override
    public void render(GuiGraphics gui, int p_230430_2_, int p_230430_3_, float pTick) {
        super.render(gui, p_230430_2_, p_230430_3_, pTick);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.hovered) {
            this.renderBtn(gui, 20, 0);
        } else {
            this.renderBtn(gui, 0, 0);
        }
        if (this.checked) {
            this.renderBtn(gui, 20, 20);
        } else {
            this.renderBtn(gui, 0, 20);
        }
    }

    private void renderBtn(GuiGraphics gui, int offsetX, int offsetY) {
        RenderHelper.drawTextureWithBorder(gui, this.BG, this.x, this.y, this.width, this.height, offsetX, offsetY, 2, 20, 40);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onChanged(CheckBox var1);
    }
}

