/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.widgets.ButtonWidget;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.utils.RenderHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class CustomButton
extends ButtonWidget {
    private final ResourceLocation icon;
    private final ResourceLocation BG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/btn_bg.png");
    private final boolean pressed;

    public CustomButton(int x, int y, int width, int height, String text) {
        this(x, y, width, height, text, null, false);
    }

    public CustomButton(int x, int y, int width, int height, String text, ResourceLocation icon, boolean pressed) {
        super(x, y, width, height, text);
        this.icon = icon;
        this.pressed = pressed;
    }

    public CustomButton(int x, int y, int width, int height, String text, ResourceLocation icon, boolean pressed, Widget.ITooltip iTooltip) {
        super(x, y, width, height, text, iTooltip);
        this.icon = icon;
        this.pressed = pressed;
    }

    private void renderBtnBg(GuiGraphics gui, int offsetX) {
        RenderHelper.drawTextureWithBorder(gui, this.BG, this.x, this.y, this.width, this.height, offsetX, 0, 2, 16, 32);
    }

    private void renderPressedBg(GuiGraphics gui) {
        RenderHelper.drawTextureWithBorder(gui, this.BG, this.x - 3, this.y - 3, this.width + 6, this.height + 6, 16, 16, 3, 16, 32);
    }

    @Override
    public void render(GuiGraphics gui, int mx, int my, float pTick) {
        super.render(gui, mx, my, pTick);
        Minecraft mc = Minecraft.getInstance();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.pressed) {
            this.renderPressedBg(gui);
        }
        if (this.hovered) {
            this.renderBtnBg(gui, 16);
        } else {
            this.renderBtnBg(gui, 0);
        }
        if (this.icon != null) {
            RenderHelper.drawTexture(gui, this.icon, this.x + this.width / 2 - 16, this.y + this.height / 2 - 16, 32, 32);
        } else {
            gui.drawCenteredString(mc.font, this.getMessage(), this.x + this.width / 2, this.y + this.height / 2 - 4, -1);
        }
    }

    @Override
    public boolean mouseClicked(double mx, double my, int md) {
        if (this.pressed) {
            return false;
        }
        return super.mouseClicked(mx, my, md);
    }
}

