/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;

public class HotBarArmorRenderer
extends ArmorRenderer {
    private final int[] armorPosX = new int[]{-96, -96, 96, 96, 96, -96};
    private final int[] armorPosY = new int[]{56, 38, 56, 38, 74, 74, 20, 20};

    public HotBarArmorRenderer(Minecraft mc) {
        super(mc);
    }

    @Override
    public void render(GuiGraphics gui, int width, int height) {
        int seed = 40;
        int iconOff = (int)(-16.0f * this.armScale);
        boolean hr = this.mc.player.getMainArm().equals((Object)HumanoidArm.RIGHT);
        boolean emptyOff = this.mc.player.getOffhandItem().isEmpty();
        Object[] leftX = this.getLeftX(width, this.armScale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        Object[] rightX = this.getRightX(width, this.armScale, emptyOff, this.armView.equals((Object)InvConfig.ArmorView.OFF), hr);
        Object[] leftXScaled = (Object[])leftX.clone();
        Object[] rightXScaled = (Object[])rightX.clone();
        if (this.armScale >= 1.0f) {
            leftXScaled[0] = width / 2 + iconOff;
            rightXScaled[0] = width / 2;
            if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                leftXScaled[0] = (int)((float)((Integer)leftXScaled[0]).intValue() - 24.0f * this.armScale);
                rightXScaled[0] = (int)((float)((Integer)rightXScaled[0]).intValue() + 24.0f * this.armScale);
            }
            leftXScaled[1] = !this.armView.equals((Object)InvConfig.ArmorView.OFF);
            rightXScaled[1] = this.armView.equals((Object)InvConfig.ArmorView.OFF);
        }
        this.preRender(gui, 0, 0);
        if (this.showMain) {
            seed = this.renderSlot(gui, (Integer)leftXScaled[0] + this.armorPosX[5], (int)((float)height - (float)(this.armorPosY[5] - (this.showArmor ? 0 : 36)) * this.armScale), (Boolean)leftXScaled[1], this.mc.player.getMainHandItem(), 5, seed);
        }
        if (this.showOff) {
            seed = this.renderSlot(gui, (Integer)rightXScaled[0] + this.armorPosX[4], (int)((float)height - (float)(this.armorPosY[4] - (this.showArmor ? 0 : 36)) * this.armScale), (Boolean)rightXScaled[1], this.mc.player.getOffhandItem(), 4, seed);
        }
        if (this.showArmor) {
            seed = this.renderSlot(gui, (Integer)rightXScaled[0] + this.armorPosX[3], (int)((float)height - (float)this.armorPosY[3] * this.armScale), (Boolean)rightXScaled[1], this.mc.player.getItemBySlot(EquipmentSlot.FEET), 3, seed);
            seed = this.renderSlot(gui, (Integer)rightXScaled[0] + this.armorPosX[2], (int)((float)height - (float)this.armorPosY[2] * this.armScale), (Boolean)rightXScaled[1], this.mc.player.getItemBySlot(EquipmentSlot.LEGS), 2, seed);
            seed = this.renderSlot(gui, (Integer)leftXScaled[0] + this.armorPosX[1], (int)((float)height - (float)this.armorPosY[1] * this.armScale), (Boolean)leftXScaled[1], this.mc.player.getItemBySlot(EquipmentSlot.CHEST), 1, seed);
            this.renderSlot(gui, (Integer)leftXScaled[0] + this.armorPosX[0], (int)((float)height - (float)this.armorPosY[0] * this.armScale), (Boolean)leftXScaled[1], this.mc.player.getItemBySlot(EquipmentSlot.HEAD), 0, seed);
        }
        if (this.showInv || this.showArrows) {
            int[] values = this.getFreeAndAmmo();
            if (this.showArrows()) {
                this.pushAndRender(gui, (Integer)leftX[0], (int)((float)height - (float)this.armorPosY[7] * this.armScale), (Boolean)leftX[1], this.armorRL[7], null, "" + values[1], false, this.armScale, 0);
            }
            if (this.showInv) {
                this.pushAndRender(gui, (Integer)rightX[0], (int)((float)height - (float)this.armorPosY[7] * this.armScale), (Boolean)rightX[1], this.armorRL[6], null, "" + values[0], false, this.armScale, 0);
            }
        }
        this.postRender(gui);
    }

    private int renderSlot(GuiGraphics gui, int xOffset, int yOffset, boolean right, ItemStack item, int index, int seed) {
        int damage = ArmorStatus.getDamage(item);
        if (damage >= 0 && damage <= this.armAbove) {
            String text = this.getText(item, damage);
            this.pushAndRender(gui, xOffset, yOffset, right, null, item, text, this.armBars, this.armScale, seed++);
        } else if (damage == -2) {
            boolean over = true;
            String text = null;
            if ((index == 5 || index == 4) && this.showCount) {
                text = String.valueOf(this.getItemCount(item));
                over = false;
            }
            this.pushAndRender(gui, xOffset, yOffset, right, null, item, text, over, this.armScale, seed++);
        } else if (this.showEmpty) {
            this.pushAndRender(gui, xOffset, yOffset, right, this.armorRL[index], null, null, false, this.armScale, 0);
        }
        return seed;
    }

    private Object[] getRightX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int offset = !avOff || !empty && !hRight ? (!empty && !hRight && scale < 1.0f ? 26 : (int)(24.0f * scale)) : 0;
        boolean right = avOff || !hRight && !empty;
        return new Object[]{width / 2 + 96 + offset, right};
    }

    private Object[] getLeftX(int width, float scale, boolean empty, boolean avOff, boolean hRight) {
        int iconOffset = (int)(-16.0f * scale);
        int offset = !avOff || !empty && hRight ? (!empty && hRight && scale < 1.0f ? -26 : (int)(-24.0f * scale)) : 0;
        boolean right = !avOff && (!hRight || empty);
        return new Object[]{width / 2 - 96 + iconOffset + offset, right};
    }

    private void pushAndRender(GuiGraphics gui, int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale, int seed) {
        gui.pose().pushPose();
        gui.pose().translate((double)x, (double)y, 0.0);
        gui.pose().scale(scale, scale, 1.0f);
        this.renderElement(gui, right, resourceLocation, itemStack, text, over, seed);
        gui.pose().popPose();
    }
}

