/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.utils.RenderHelper;
import dlovin.inventoryhud.utils.WidgetAligns;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class TextWidget
extends Widget {
    private final int color;
    private final Font fontRenderer;
    private final boolean withTooltip;
    private static final ResourceLocation TT_ICON = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/tt_icon.png");

    public TextWidget(int x, int y, int color, WidgetAligns.HAlign align, String text, Font fontRenderer) {
        super(x - 5, y - 9, fontRenderer.width(text) + 10, 18, text);
        switch (align) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                this.x -= this.width - 10;
                break;
            }
            case MIDDLE: {
                this.x -= (this.width - 10) / 2;
            }
        }
        this.color = color;
        this.fontRenderer = fontRenderer;
        this.withTooltip = false;
    }

    public TextWidget(int x, int y, int color, WidgetAligns.HAlign align, String text, Font fontRenderer, Widget.ITooltip tooltip) {
        super(x - 5, y - 9, fontRenderer.width(text) + 10, 18, text, tooltip);
        switch (align) {
            case LEFT: {
                break;
            }
            case RIGHT: {
                this.x -= this.width - 10;
                break;
            }
            case MIDDLE: {
                this.x -= (this.width - 10) / 2;
            }
        }
        this.color = color;
        this.fontRenderer = fontRenderer;
        this.withTooltip = true;
    }

    @Override
    public void render(GuiGraphics gui, int mouseX, int mouseY, float pTick) {
        super.render(gui, mouseX, mouseY, pTick);
        gui.drawString(this.fontRenderer, this.getMessage(), this.x + 5, this.y + 5, this.color);
        if (this.withTooltip) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderHelper.drawTexture(gui, TT_ICON, this.x + this.width - 8, this.y, 8, 8);
        }
    }

    @Override
    public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        return false;
    }
}

