/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.HudRenderer;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.RenderHelper;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1744;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;

public class ArmorRenderer
extends HudRenderer {
    protected static Predicate<class_1799> AMMO_TYPES = i -> i.method_7909() instanceof class_1744;
    public boolean showMain;
    public boolean showOff;
    public boolean showArmor;
    public boolean showEmpty;
    public boolean showInv;
    public boolean showArrows;
    public boolean armBars;
    public boolean showCount;
    public boolean withDebug;
    public boolean showArrowsWithoutWeapon;
    public int armX;
    public int armY;
    public int armAbove;
    public float armScale;
    public WidgetAligns ArmAligns;
    public InvConfig.ArmorView armView;
    public EachItem[] items = new EachItem[8];
    class_310 mc;
    class_327 fontRenderer;
    class_918 itemRenderer;
    class_2960[] armorRL = new class_2960[]{class_2960.method_43902((String)"inventoryhud", (String)"textures/item/empty_armor_slot_helmet.png"), class_2960.method_43902((String)"inventoryhud", (String)"textures/item/empty_armor_slot_chestplate.png"), class_2960.method_43902((String)"inventoryhud", (String)"textures/item/empty_armor_slot_leggings.png"), class_2960.method_43902((String)"inventoryhud", (String)"textures/item/empty_armor_slot_boots.png"), class_2960.method_43902((String)"inventoryhud", (String)"textures/item/empty_armor_slot_shield.png"), class_2960.method_43902((String)"inventoryhud", (String)"textures/item/empty_main_hand_slot.png"), class_2960.method_43902((String)"inventoryhud", (String)"textures/item/inventory.png"), class_2960.method_43902((String)"inventoryhud", (String)"textures/item/arrows.png")};

    public ArmorRenderer(class_310 mc) {
        this.mc = mc;
        this.fontRenderer = mc.field_1772;
        this.itemRenderer = mc.method_1480();
    }

    protected String getText(class_1799 item, int damage) {
        return switch (this.armView) {
            default -> throw new MatchException(null, null);
            case InvConfig.ArmorView.PERCENTAGE -> this.getDamageText(String.valueOf(damage), damage) + String.valueOf(class_124.field_1068) + "%";
            case InvConfig.ArmorView.DAMAGE -> this.getDamageText(String.valueOf(item.method_7919()), damage);
            case InvConfig.ArmorView.DAMAGE_LEFT -> this.getDamageText(String.valueOf(item.method_7936() - item.method_7919()), damage);
            case InvConfig.ArmorView.OFF -> null;
        };
    }

    private String getDamageText(String p, int d) {
        Object result = p;
        if (d == 100) {
            result = String.valueOf(class_124.field_1060) + (String)result;
        } else if (d < 1) {
            result = String.valueOf(class_124.field_1079) + (String)result;
        } else if (d <= 10) {
            result = String.valueOf(class_124.field_1061) + (String)result;
        } else if (d <= 25) {
            result = String.valueOf(class_124.field_1065) + (String)result;
        } else if (d <= 50) {
            result = String.valueOf(class_124.field_1054) + (String)result;
        }
        return result;
    }

    protected boolean showArrows() {
        return this.showArrows && (this.withProjectileWeapon(this.mc.field_1724.method_6047(), this.mc.field_1724.method_6079()) || this.showArrowsWithoutWeapon);
    }

    private boolean withProjectileWeapon(class_1799 mainHand, class_1799 offHand) {
        return mainHand.method_7909() instanceof class_1811 || offHand.method_7909() instanceof class_1811;
    }

    Predicate<class_1799> getAllProj(class_1799 mainHand, class_1799 offHand) {
        class_1792 class_17922 = mainHand.method_7909();
        if (class_17922 instanceof class_1811) {
            class_1811 item = (class_1811)class_17922;
            return item.method_20310().and(i -> offHand == i).or(item.method_19268());
        }
        class_17922 = offHand.method_7909();
        if (class_17922 instanceof class_1811) {
            class_1811 item = (class_1811)class_17922;
            return item.method_20310().and(i -> mainHand == i).or(item.method_19268());
        }
        return AMMO_TYPES;
    }

    protected int[] getFreeAndAmmo() {
        int[] result = new int[]{0, 0};
        Predicate<class_1799> ammoTypes = this.getAllProj(this.mc.field_1724.method_6047(), this.mc.field_1724.method_6079());
        for (class_1799 slot : this.mc.field_1724.method_31548().method_67533()) {
            if (slot.method_7960()) {
                result[0] = result[0] + 1;
                continue;
            }
            if (!this.isAmmo(slot, ammoTypes)) continue;
            result[1] = result[1] + slot.method_7947();
        }
        if (this.isAmmo(this.mc.field_1724.method_6079(), ammoTypes)) {
            result[1] = result[1] + this.mc.field_1724.method_6079().method_7947();
        }
        return result;
    }

    boolean isAmmo(class_1799 stack, Predicate<class_1799> ammoTypes) {
        return !stack.method_7960() && ammoTypes.test(stack);
    }

    int getItemCount(class_1799 item) {
        int result = 0;
        for (class_1799 slot : this.mc.field_1724.method_31548().method_67533()) {
            if (!class_1799.method_7984((class_1799)slot, (class_1799)item)) continue;
            result += slot.method_7947();
        }
        if (class_1799.method_7984((class_1799)this.mc.field_1724.method_6079(), (class_1799)item)) {
            result += this.mc.field_1724.method_6079().method_7947();
        }
        return result;
    }

    boolean getRight(int x, WidgetAligns.HAlign hal) {
        return switch (hal) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.HAlign.LEFT -> false;
            case WidgetAligns.HAlign.MIDDLE -> {
                if (x > 0) {
                    yield true;
                }
                yield false;
            }
            case WidgetAligns.HAlign.RIGHT -> true;
        };
    }

    void renderElementInBlock(class_332 context, int x, int y, int offSetX, int offSetY, float scale, boolean right, @Nullable class_2960 res, @Nullable class_1799 item, @Nullable String text, boolean overlay, int seed) {
        if (res != null) {
            RenderHelper.drawTexture(context, res, offSetX, offSetY, 16, 16);
        } else {
            class_4587 matrixStack = context.method_51448();
            matrixStack.method_22903();
            matrixStack.method_22904((double)offSetX, (double)offSetY, -256.0);
            context.method_51423((class_1309)this.mc.field_1724, item, 0, 0, seed);
            if (overlay) {
                context.method_51431(this.fontRenderer, item, 0, 0);
            }
            matrixStack.method_22909();
        }
        if (text == null) {
            return;
        }
        if (right) {
            context.method_25303(this.fontRenderer, text, offSetX + 17, offSetY + 4, 0xFFFFFF);
        } else {
            context.method_25303(this.fontRenderer, text, offSetX - 1 - this.fontRenderer.method_1727(text), offSetY + 4, 0xFFFFFF);
        }
    }

    void renderElement(class_332 context, boolean right, @Nullable class_2960 res, @Nullable class_1799 item, @Nullable String text, boolean overlay, int seed) {
        if (res != null) {
            RenderHelper.drawTexture(context, res, 16);
        } else {
            class_4587 matrixStack = context.method_51448();
            matrixStack.method_22903();
            context.method_51423((class_1309)this.mc.field_1724, item, 0, 0, seed);
            if (overlay) {
                context.method_51431(this.fontRenderer, item, 0, 0);
            }
            matrixStack.method_22909();
        }
        if (text == null) {
            return;
        }
        if (right) {
            context.method_25303(this.fontRenderer, text, 17, 4, 0xFFFFFF);
        } else {
            context.method_25303(this.fontRenderer, text, -1 - this.fontRenderer.method_1727(text), 4, 0xFFFFFF);
        }
    }

    public void render(class_332 context, int width, int height) {
    }

    protected void preRender(class_332 context, int x, int y) {
        context.method_51448().method_22903();
        context.method_51448().method_22904((double)x, (double)y, -256.0);
    }

    protected void postRender(class_332 context) {
        context.method_51448().method_22909();
    }
}

