/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.gui.HudRenderer;
import dlovin.inventoryhud.utils.RenderHelper;
import dlovin.inventoryhud.utils.StringUtils;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_6880;
import net.minecraft.class_9848;

public class PotionRenderer
extends HudRenderer {
    private final class_2960 POTION_DIGITS = class_2960.method_43902((String)"inventoryhud", (String)"textures/gui/potion_digits.png");
    public int potX;
    public int potY;
    public int potSide;
    public int potIconSide;
    public int potTextSide;
    public int potVert;
    public int barDuration;
    public int potGap;
    public boolean potMini;
    public boolean showHidden;
    public boolean withDebug;
    public boolean potionLevels;
    public float potAlpha;
    public WidgetAligns PotAligns;
    public Set<String> blackList;
    class_310 mc;
    class_327 fontRenderer;
    final class_2960 PMT = class_2960.method_43902((String)"inventoryhud", (String)"textures/gui/potminitime.png");
    protected final int BG_WIDTH;
    protected final int BG_HEIGHT;
    protected final int ICON_SIZE;

    public PotionRenderer(class_310 mc, int bgWidth, int bgHeight, int iconSize) {
        this.mc = mc;
        this.fontRenderer = mc.field_1772;
        this.BG_WIDTH = bgWidth;
        this.BG_HEIGHT = bgHeight;
        this.ICON_SIZE = iconSize;
    }

    public void render(class_332 context, int width, int height) {
    }

    protected void preDraw(class_332 context) {
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22904(0.0, 0.0, -255.0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected List<class_1293> filteredEffects() {
        return this.mc.field_1724.method_6026().stream().filter(e -> (e.method_5592() || this.showHidden) && !this.getBlackList().contains(e.method_5586())).toList();
    }

    int getBarColorByScale(float scale) {
        float r = 1.0f;
        float g = 1.0f;
        if (scale < 0.5f) {
            g = scale / 0.5f;
        } else {
            r = 1.0f - (scale - 0.5f) / 0.5f;
        }
        return class_9848.method_61318((float)1.0f, (float)r, (float)g, (float)0.0f);
    }

    float getBarScale(class_1293 effect) {
        int dur = effect.method_5584();
        return effect.method_48559() ? 1.0f : Math.min((float)dur / (float)this.barDuration, 1.0f);
    }

    int getBarSize(float scale) {
        return Math.max(1, (int)(scale * 12.0f));
    }

    void drawBackground(class_332 context, class_2960 bgResource, int x, int y, int bgXScale, int bgYScale) {
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.drawTexture(context, bgResource, x, y, this.BG_WIDTH, this.BG_HEIGHT, this.BG_WIDTH * bgXScale, this.BG_HEIGHT * bgYScale, class_9848.method_61317((float)this.potAlpha));
        matrixStack.method_22909();
    }

    void drawIcon(class_332 context, class_6880<class_1291> effect, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_1058 sprite = this.mc.method_18505().method_18663(effect);
        RenderHelper.drawSprite(context, sprite, x, y, this.ICON_SIZE);
    }

    void drawLevel(class_332 context, int x, int y, int level) {
        boolean sign;
        int xOffset = -2;
        int yOffset = 1;
        if (!(++level >= 1 && level <= 9 || this.potionLevels)) {
            RenderHelper.drawTexture(context, this.POTION_DIGITS, x - xOffset - 1, y + yOffset, 50, 0, 7, 7, 64, 7);
            return;
        }
        boolean bl = sign = level < 0;
        while (level > 0) {
            int digit = level % 10;
            int texX = digit * 5;
            RenderHelper.drawTexture(context, this.POTION_DIGITS, x - xOffset, y + yOffset, texX, 0, 5, 7, 64, 7);
            xOffset += 4;
            level /= 10;
        }
        if (sign) {
            RenderHelper.drawTexture(context, this.POTION_DIGITS, x - xOffset, y + yOffset, 57, 0, 4, 7, 64, 7);
        }
    }

    void drawDurationBar(class_332 context, class_1293 effect, int x, int y, int width, int height) {
        RenderHelper.drawRect(context, x, y, width, height, this.getBarColorByScale(this.getBarScale(effect)));
    }

    void drawDuration(class_332 context, class_1293 effect, int x, int y) {
        String time = " **:**";
        int duration = effect.method_5584() / 20;
        if (!effect.method_48559() && duration < 1600) {
            int minutes = duration / 60;
            int seconds = duration % 60;
            time = duration > 10 ? String.format("%02d:%02d", minutes, seconds) : String.format("%s%02d%s:%s%02d", class_124.field_1061, minutes, class_124.field_1068, class_124.field_1061, seconds);
        }
        context.method_25303(this.fontRenderer, time, x, y, 0xFFFFFF);
    }

    void postDraw(class_332 context) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.method_51448().method_22909();
    }

    private void PotPosVertChanged() {
        switch (this.PotAligns.HorAlign) {
            case RIGHT: {
                if (!this.potMini) {
                    this.potSide = -1;
                    this.potIconSide = 36;
                    this.potTextSide = -22;
                    break;
                }
                this.potSide = -1;
                this.potIconSide = 4;
                this.potTextSide = -15;
                break;
            }
            case MIDDLE: {
                if (this.potX > 0) {
                    if (!this.potMini) {
                        this.potSide = -1;
                        this.potIconSide = 36;
                        this.potTextSide = -22;
                        break;
                    }
                    this.potSide = -1;
                    this.potIconSide = 4;
                    this.potTextSide = -15;
                    break;
                }
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
                break;
            }
            case LEFT: {
                this.potSide = 1;
                this.potIconSide = 0;
                this.potTextSide = 0;
            }
        }
    }

    public void PotPosChanged() {
        if (InventoryHUD.getConfig().isPotHor()) {
            this.PotPosHorChanged();
        } else {
            this.PotPosVertChanged();
        }
    }

    private void PotPosHorChanged() {
        switch (this.PotAligns.VertAlign) {
            case TOP: {
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case CENTER: {
                if (this.potY > 0) {
                    this.potSide = -1;
                    this.potTextSide = 2;
                    this.potIconSide = 4;
                    break;
                }
                this.potSide = 1;
                this.potTextSide = 17;
                this.potIconSide = 0;
                break;
            }
            case BOTTOM: {
                this.potSide = -1;
                this.potTextSide = 2;
                this.potIconSide = 4;
            }
        }
    }

    public void PotPosYChanged(boolean top) {
        this.potVert = top ? 1 : -1;
    }

    public Set<String> getBlackList() {
        if (this.blackList == null) {
            this.resetBlacklist();
        }
        return this.blackList;
    }

    public void resetBlacklist() {
        this.blackList = StringUtils.effectDescIdsSet(InventoryHUD.getConfig().getEffectsBlacklist());
    }
}

