/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import dlovin.inventoryhud.gui.widgets.Widget;
import dlovin.inventoryhud.utils.RenderHelper;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class TextField
extends Widget {
    protected final IPressable onChange;
    private final Font fontRenderer;
    protected String text;
    protected int maxStringLength = 255;
    protected boolean isFocused;
    protected boolean isShiftDown;
    private int lineScrollOffset;
    protected int cursorPosition;
    protected int selectionEnd;
    protected String prevText;
    private final ResourceLocation BG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/tf_bg.png");
    protected Predicate<String> validator = Objects::nonNull;
    private final BiFunction<String, Integer, String> textFormatter = (string, integer) -> string;

    @Deprecated
    public TextField(Font font, int x, int y, int width, int height, String text) {
        this(font, x, y, width, height, text, p -> {});
    }

    public TextField(Font font, int x, int y, int width, int height, String text, IPressable onChange) {
        this(font, x, y, width, height, text, onChange, null);
    }

    public TextField(Font font, int x, int y, int width, int height, String text, IPressable onChange, String regex) {
        super(x, y, width, height, text);
        this.text = this.prevText = text;
        this.fontRenderer = font;
        this.onChange = onChange;
        if (regex != null) {
            this.validator = s -> Pattern.matches(regex, s);
        }
    }

    public void setText(String textIn) {
        if (this.validator.test(textIn)) {
            this.text = textIn.length() > this.maxStringLength ? textIn.substring(0, this.maxStringLength) : textIn;
            this.setCursorPositionEnd();
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(textIn);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getSelectedText() {
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        return this.text.substring(i, j);
    }

    public void writeText(String textToWrite) {
        String s1;
        String s;
        int l;
        int i = Math.min(this.cursorPosition, this.selectionEnd);
        int j = Math.max(this.cursorPosition, this.selectionEnd);
        int k = this.maxStringLength - this.text.length() - (i - j);
        if (k < (l = (s = StringUtil.filterText((String)textToWrite)).length())) {
            s = s.substring(0, k);
            l = k;
        }
        if (this.validator.test(s1 = new StringBuilder(this.text).replace(i, j, s).toString())) {
            this.text = s1;
            this.clampCursorPosition(i + l);
            this.setSelectionPos(this.cursorPosition);
            this.onTextChanged(this.text);
        }
    }

    private void onTextChanged(String newText) {
        if (!newText.equals(this.prevText)) {
            this.prevText = newText;
            this.onChange.onChanged(this);
        }
    }

    protected void delete(int p_212950_1_) {
        if (Screen.hasControlDown()) {
            this.deleteWords(p_212950_1_);
        } else {
            this.deleteFromCursor(p_212950_1_);
        }
    }

    public void deleteWords(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getNthWordFromCursor(num) - this.cursorPosition);
            }
        }
    }

    public void deleteFromCursor(int num) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                String s;
                int k;
                int i = this.func_238516_r_(num);
                int j = Math.min(i, this.cursorPosition);
                if (j != (k = Math.max(i, this.cursorPosition)) && this.validator.test(s = new StringBuilder(this.text).delete(j, k).toString())) {
                    this.text = s;
                    this.setCursorPosition(j);
                }
            }
        }
    }

    public int getNthWordFromCursor(int numWords) {
        return this.getNthWordFromPos(numWords, this.getCursorPosition());
    }

    private int getNthWordFromPos(int n, int pos) {
        return this.getNthWordFromPosWS(n, pos, true);
    }

    private int getNthWordFromPosWS(int n, int pos, boolean skipWs) {
        int i = pos;
        boolean flag = n < 0;
        int j = Math.abs(n);
        for (int k = 0; k < j; ++k) {
            if (!flag) {
                int l = this.text.length();
                if ((i = this.text.indexOf(32, i)) == -1) {
                    i = l;
                    continue;
                }
                while (skipWs && i < l && this.text.charAt(i) == ' ') {
                    ++i;
                }
                continue;
            }
            while (skipWs && i > 0 && this.text.charAt(i - 1) == ' ') {
                --i;
            }
            while (i > 0 && this.text.charAt(i - 1) != ' ') {
                --i;
            }
        }
        return i;
    }

    public void moveCursorBy(int num) {
        this.setCursorPosition(this.func_238516_r_(num));
    }

    private int func_238516_r_(int p_238516_1_) {
        return Util.offsetByCodepoints((String)this.text, (int)this.cursorPosition, (int)p_238516_1_);
    }

    public void setCursorPosition(int pos) {
        this.clampCursorPosition(pos);
        if (!this.isShiftDown) {
            this.setSelectionPos(this.cursorPosition);
        }
        this.onTextChanged(this.text);
    }

    public void clampCursorPosition(int pos) {
        this.cursorPosition = this.clamp0(pos, this.text.length());
    }

    public void setCursorPositionZero() {
        this.setCursorPosition(0);
    }

    public void setCursorPositionEnd() {
        this.setCursorPosition(this.text.length());
    }

    @Override
    public boolean keyPressed(int keyCode, int p_231046_2_, int p_231046_3_) {
        if (!this.canWrite()) {
            return false;
        }
        this.isShiftDown = Screen.hasShiftDown();
        if (Screen.isSelectAll((int)keyCode)) {
            this.setCursorPositionEnd();
            this.setSelectionPos(0);
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getSelectedText());
            return true;
        }
        if (Screen.isPaste((int)keyCode)) {
            this.writeText(Minecraft.getInstance().keyboardHandler.getClipboard());
            return true;
        }
        if (Screen.isCut((int)keyCode)) {
            Minecraft.getInstance().keyboardHandler.setClipboard(this.getSelectedText());
            this.writeText("");
            return true;
        }
        switch (keyCode) {
            case 256: {
                this.setFocused2(false);
                return true;
            }
            case 259: {
                this.isShiftDown = false;
                this.delete(-1);
                this.isShiftDown = Screen.hasShiftDown();
                return true;
            }
            default: {
                return false;
            }
            case 261: {
                this.isShiftDown = false;
                this.delete(1);
                this.isShiftDown = Screen.hasShiftDown();
                return true;
            }
            case 262: {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(1));
                } else {
                    this.moveCursorBy(1);
                }
                return true;
            }
            case 263: {
                if (Screen.hasControlDown()) {
                    this.setCursorPosition(this.getNthWordFromCursor(-1));
                } else {
                    this.moveCursorBy(-1);
                }
                return true;
            }
            case 268: {
                this.setCursorPositionZero();
                return true;
            }
            case 269: 
        }
        this.setCursorPositionEnd();
        return true;
    }

    public boolean canWrite() {
        return this.getVisible() && this.isFocused() && this.isEnabled();
    }

    @Override
    public boolean isFocused() {
        return this.isFocused;
    }

    @Override
    public boolean charTyped(char character, int p_231042_2_) {
        if (!this.canWrite()) {
            return false;
        }
        this.writeText(Character.toString(character));
        return true;
    }

    @Override
    public boolean mouseClicked(double p_231044_1_, double p_231044_3_, int p_231044_5_) {
        if (!this.getVisible()) {
            return false;
        }
        boolean flag = p_231044_1_ >= (double)this.x && p_231044_1_ < (double)(this.x + this.width) && p_231044_3_ >= (double)this.y && p_231044_3_ < (double)(this.y + this.height);
        this.setFocused2(flag);
        if (this.isFocused() && flag && p_231044_5_ == 0) {
            int i = this.floor(p_231044_1_) - this.x - 4;
            String s = this.fontRenderer.plainSubstrByWidth(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            this.setCursorPosition(this.fontRenderer.plainSubstrByWidth(s, i).length() + this.lineScrollOffset);
            return true;
        }
        return false;
    }

    public void setFocused2(boolean isFocusedIn) {
        this.isFocused = isFocusedIn;
        if (!isFocusedIn) {
            this.isShiftDown = false;
            this.setCursorPosition(0);
        }
    }

    @Override
    public void render(GuiGraphics gui, int p_230431_2_, int p_230431_3_, float pTick) {
        super.render(gui, p_230431_2_, p_230431_3_, pTick);
        if (this.getVisible()) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            if (this.isFocused()) {
                this.renderBtnBg(gui, 0, 16);
            } else if (this.hovered) {
                this.renderBtnBg(gui, 16, 0);
            } else {
                this.renderBtnBg(gui, 0, 0);
            }
            RenderSystem.disableBlend();
            int enabledColor = 0xE0E0E0;
            int j = this.cursorPosition - this.lineScrollOffset;
            int k = this.selectionEnd - this.lineScrollOffset;
            String s = this.fontRenderer.plainSubstrByWidth(this.text.substring(this.lineScrollOffset), this.getAdjustedWidth());
            boolean flag = j >= 0 && j <= s.length();
            boolean flag1 = this.isFocused() && flag;
            int l = this.x + 4;
            int i1 = this.y + (this.height - 8) / 2;
            int j1 = l;
            if (k > s.length()) {
                k = s.length();
            }
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 = gui.drawString(this.fontRenderer, this.textFormatter.apply(s1, this.lineScrollOffset), l, i1, enabledColor);
            }
            boolean flag2 = this.cursorPosition < this.text.length() || this.text.length() >= this.getMaxStringLength();
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + this.width : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            if (!s.isEmpty() && flag && j < s.length()) {
                gui.drawString(this.fontRenderer, this.textFormatter.apply(s.substring(j), this.cursorPosition), j1, i1, enabledColor);
            }
            if (flag1) {
                if (flag2) {
                    gui.fill(k1, i1 - 1, k1 + 1, i1 + 1 + 9, -3092272);
                } else {
                    gui.drawString(this.fontRenderer, "_", k1, i1, enabledColor);
                }
            }
            if (k != j) {
                int l1 = l + this.fontRenderer.width(s.substring(0, k));
                this.drawSelectionBox(gui, k1, i1 - 1, l1 - 1, i1 + 1 + 9);
            }
        }
    }

    private void drawSelectionBox(GuiGraphics context, int startX, int startY, int endX, int endY) {
        if (startX < endX) {
            int i = startX;
            startX = endX;
            endX = i;
        }
        if (startY < endY) {
            int j = startY;
            startY = endY;
            endY = j;
        }
        if (endX > this.x + this.width) {
            endX = this.x + this.width;
        }
        if (startX > this.x + this.width) {
            startX = this.x + this.width;
        }
        context.fill(RenderType.guiTextHighlight(), startX, startY, endX, endY, -16776961);
    }

    public void setMaxStringLength(int length) {
        this.maxStringLength = length;
        if (this.text.length() > length) {
            this.text = this.text.substring(0, length);
            this.onTextChanged(this.text);
        }
    }

    private int getMaxStringLength() {
        return this.maxStringLength;
    }

    public int getCursorPosition() {
        return this.cursorPosition;
    }

    private boolean getEnableBackgroundDrawing() {
        return true;
    }

    @Override
    public boolean isMouseOver(double p_231047_1_, double p_231047_3_) {
        return p_231047_1_ >= (double)this.x && p_231047_1_ < (double)(this.x + this.width) && p_231047_3_ >= (double)this.y && p_231047_3_ < (double)(this.y + this.height);
    }

    private boolean isEnabled() {
        return true;
    }

    public int getAdjustedWidth() {
        return this.getEnableBackgroundDrawing() ? this.width - 8 : this.width;
    }

    public void setSelectionPos(int position) {
        int i = this.text.length();
        this.selectionEnd = this.clamp0(position, i);
        if (this.fontRenderer != null) {
            if (this.lineScrollOffset > i) {
                this.lineScrollOffset = i;
            }
            int j = this.getAdjustedWidth();
            String s = this.fontRenderer.plainSubstrByWidth(this.text.substring(this.lineScrollOffset), j);
            int k = s.length() + this.lineScrollOffset;
            if (this.selectionEnd == this.lineScrollOffset) {
                this.lineScrollOffset -= this.fontRenderer.plainSubstrByWidth(this.text, j, true).length();
            }
            if (this.selectionEnd > k) {
                this.lineScrollOffset += this.selectionEnd - k;
            } else if (this.selectionEnd <= this.lineScrollOffset) {
                this.lineScrollOffset -= this.lineScrollOffset - this.selectionEnd;
            }
            this.lineScrollOffset = this.clamp0(this.lineScrollOffset, i);
        }
    }

    public boolean getVisible() {
        return true;
    }

    public void setX(int xIn) {
        this.x = xIn;
    }

    private void renderBtnBg(GuiGraphics gui, int offsetX, int offsetY) {
        RenderHelper.drawTextureWithBorder(gui, this.BG, this.x, this.y, this.width, this.height, offsetX, offsetY, 2, 16, 32);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface IPressable {
        public void onChanged(TextField var1);
    }
}

