/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.events;

import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.references.Translation;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class UpdateNotificationEvent {
    @SubscribeEvent
    public void onPlayerJoin(EntityJoinLevelEvent event) {
        if (event.getEntity().equals((Object)Minecraft.getInstance().player)) {
            VersionChecker.CheckResult result = VersionChecker.getResult((IModInfo)((ModContainer)ModList.get().getModContainerByObject((Object)InventoryHUD.getInstance()).get()).getModInfo());
            if (result.status().equals((Object)VersionChecker.Status.OUTDATED) && this.shouldNotify(result.target())) {
                MutableComponent text = Component.literal((String)(String.valueOf(ChatFormatting.GRAY) + "[" + String.valueOf(ChatFormatting.GREEN) + "InventoryHUD+" + String.valueOf(ChatFormatting.GRAY) + "] " + String.valueOf(ChatFormatting.WHITE) + Translation.UPDATE.getString()));
                ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, result.url());
                MutableComponent link = Component.literal((String)("[" + String.valueOf(ChatFormatting.YELLOW) + Translation.UPDATE_CLICK.getString() + String.valueOf(ChatFormatting.WHITE) + "]"));
                link.setStyle(link.getStyle().withClickEvent(clickEvent));
                text.append((Component)link);
                ((LocalPlayer)event.getEntity()).displayClientMessage((Component)text, false);
                InventoryHUD.getClientConfig().lastNotifiedVersion.set((Object)result.target().toString());
                InventoryHUD.saveConfig();
            }
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    private boolean shouldNotify(ComparableVersion version) {
        if (version == null) {
            return false;
        }
        ComparableVersion lastNotified = new ComparableVersion((String)InventoryHUD.getClientConfig().lastNotifiedVersion.get());
        return version.compareTo(lastNotified) > 0 || (Boolean)InventoryHUD.getClientConfig().keepNotifying.get() != false;
    }
}

