/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.gui.renderers.BlockArmorRenderer;
import dlovin.inventoryhud.gui.renderers.CuriosRenderer;
import dlovin.inventoryhud.gui.renderers.EachArmorRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HotBarArmorRenderer;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalPotionRenderer;
import dlovin.inventoryhud.utils.CuriosSlot;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;

public class InventoryGui {
    private final Minecraft minecraft = Minecraft.getInstance();
    public static int invX;
    public static int invY;
    public static WidgetAligns InvAligns;
    public static float invAlpha;
    public static boolean invMini;
    public static boolean invVert;
    public static boolean animated;
    public static boolean hideBackground;
    public static boolean withDebug;
    private static final ResourceLocation INVBG;
    public ArmorRenderer armorRenderer;
    public PotionRenderer potionRenderer;
    public CuriosRenderer curiosRenderer;

    public InventoryGui() {
        this.init();
    }

    public void init() {
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
        int armX = (Integer)InventoryHUD.getClientConfig().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClientConfig().yArmPos.get();
        this.armorRenderer = (Boolean)InventoryHUD.getClientConfig().moveAll.get() == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        if (InventoryHUD.isCuriosMod) {
            this.curiosRenderer = new CuriosRenderer(this.minecraft);
        }
        this.setupArmorRenderer();
        this.potionRenderer = (Boolean)InventoryHUD.getClientConfig().potHor.get() != false ? ((Boolean)InventoryHUD.getClientConfig().potMini.get() != false ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : ((Boolean)InventoryHUD.getClientConfig().potMini.get() != false ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
        InventoryHUD.isActive = (Boolean)InventoryHUD.getClientConfig().byDefault.get();
        InventoryHUD.armorHUD = (Boolean)InventoryHUD.getClientConfig().ArmorDamage.get();
        InventoryHUD.potionHUD = (Boolean)InventoryHUD.getClientConfig().Potions.get();
        invX = (Integer)InventoryHUD.getClientConfig().xPos.get();
        invY = (Integer)InventoryHUD.getClientConfig().yPos.get();
        InvAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invValign.get()));
        invMini = (Boolean)InventoryHUD.getClientConfig().invMini.get();
        invVert = (Boolean)InventoryHUD.getClientConfig().invVert.get();
        animated = (Boolean)InventoryHUD.getClientConfig().animatedInv.get();
        hideBackground = (Boolean)InventoryHUD.getClientConfig().hideBackground.get();
        invAlpha = (float)((Integer)InventoryHUD.getClientConfig().invAlpha.get()).intValue() / 100.0f;
        withDebug = (Boolean)InventoryHUD.getClientConfig().invWithDebug.get();
    }

    private void setupPotionRenderer() {
        this.potionRenderer.potX = (Integer)InventoryHUD.getClientConfig().xPotionPos.get();
        this.potionRenderer.potY = (Integer)InventoryHUD.getClientConfig().yPotionPos.get();
        this.potionRenderer.PotAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().potHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().potValign.get()));
        this.potionRenderer.potMini = (Boolean)InventoryHUD.getClientConfig().potMini.get();
        this.potionRenderer.potGap = (Integer)InventoryHUD.getClientConfig().potGap.get();
        this.potionRenderer.barDuration = (Integer)InventoryHUD.getClientConfig().barDuration.get() * 20;
        this.potionRenderer.PotPosChanged();
        switch (this.potionRenderer.PotAligns.VertAlign) {
            case TOP: {
                this.potionRenderer.potVert = 1;
                break;
            }
            case CENTER: {
                if (this.potionRenderer.potY - 12 < this.minecraft.getWindow().getGuiScaledHeight() / 2) {
                    this.potionRenderer.potVert = -1;
                    break;
                }
                this.potionRenderer.potVert = 1;
                break;
            }
            case BOTTOM: {
                this.potionRenderer.potVert = -1;
            }
        }
        this.potionRenderer.potAlpha = (float)((Integer)InventoryHUD.getClientConfig().potAlpha.get()).intValue() / 100.0f;
        this.potionRenderer.showHidden = (Boolean)InventoryHUD.getClientConfig().showHiddenEffects.get();
        this.potionRenderer.withDebug = (Boolean)InventoryHUD.getClientConfig().potWithDebug.get();
        this.potionRenderer.potionLevels = (Boolean)InventoryHUD.getClientConfig().potionLevels.get();
    }

    private void setupArmorRenderer() {
        this.armorRenderer.armX = (Integer)InventoryHUD.getClientConfig().xArmPos.get();
        this.armorRenderer.armY = (Integer)InventoryHUD.getClientConfig().yArmPos.get();
        this.armorRenderer.ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
        this.armorRenderer.armAbove = (Integer)InventoryHUD.getClientConfig().armAbove.get();
        this.armorRenderer.armScale = (float)((Integer)InventoryHUD.getClientConfig().armScale.get()).intValue() * 0.01f;
        this.armorRenderer.showArmor = (Boolean)InventoryHUD.getClientConfig().showArmor.get();
        this.armorRenderer.showMain = (Boolean)InventoryHUD.getClientConfig().showMain.get();
        this.armorRenderer.showOff = (Boolean)InventoryHUD.getClientConfig().showOff.get();
        this.armorRenderer.showArrows = (Boolean)InventoryHUD.getClientConfig().showArrows.get();
        this.armorRenderer.showInv = (Boolean)InventoryHUD.getClientConfig().showInv.get();
        this.armorRenderer.showEmpty = (Boolean)InventoryHUD.getClientConfig().showEmpty.get();
        this.armorRenderer.showCount = (Boolean)InventoryHUD.getClientConfig().showCount.get();
        this.armorRenderer.armView = (InvConfig.ArmorView)((Object)InventoryHUD.getClientConfig().armView.get());
        this.armorRenderer.armBars = (Boolean)InventoryHUD.getClientConfig().armBars.get();
        this.armorRenderer.showArrowsWithoutWeapon = (Boolean)InventoryHUD.getClientConfig().showArrowsWithoutWeapon.get();
        this.armorRenderer.withDebug = (Boolean)InventoryHUD.getClientConfig().armWithDebug.get();
        if (InventoryHUD.isCuriosMod) {
            this.curiosRenderer.armAbove = this.armorRenderer.armAbove;
            this.curiosRenderer.armScale = this.armorRenderer.armScale;
            this.curiosRenderer.showEmpty = this.armorRenderer.showEmpty;
            this.curiosRenderer.armView = this.armorRenderer.armView;
            this.curiosRenderer.armBars = this.armorRenderer.armBars;
            this.curiosRenderer.showCount = this.armorRenderer.showCount;
        }
        this.armorRenderer.items[0] = new EachItem((Integer)InventoryHUD.getClientConfig().helmPosX.get(), (Integer)InventoryHUD.getClientConfig().helmPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().helmHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().helmVal.get())));
        this.armorRenderer.items[1] = new EachItem((Integer)InventoryHUD.getClientConfig().chestPosX.get(), (Integer)InventoryHUD.getClientConfig().chestPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().chestHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().chestVal.get())));
        this.armorRenderer.items[2] = new EachItem((Integer)InventoryHUD.getClientConfig().legPosX.get(), (Integer)InventoryHUD.getClientConfig().legPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().legHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().legVal.get())));
        this.armorRenderer.items[3] = new EachItem((Integer)InventoryHUD.getClientConfig().bootPosX.get(), (Integer)InventoryHUD.getClientConfig().bootPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().bootHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().bootVal.get())));
        this.armorRenderer.items[4] = new EachItem((Integer)InventoryHUD.getClientConfig().offPosX.get(), (Integer)InventoryHUD.getClientConfig().offPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().offHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().offVal.get())));
        this.armorRenderer.items[5] = new EachItem((Integer)InventoryHUD.getClientConfig().mainPosX.get(), (Integer)InventoryHUD.getClientConfig().mainPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().mainHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().mainVal.get())));
        this.armorRenderer.items[6] = new EachItem((Integer)InventoryHUD.getClientConfig().invPosX.get(), (Integer)InventoryHUD.getClientConfig().invPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().invHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().invVal.get())));
        this.armorRenderer.items[7] = new EachItem((Integer)InventoryHUD.getClientConfig().arrPosX.get(), (Integer)InventoryHUD.getClientConfig().arrPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().arrHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().arrVal.get())));
        this.changeArmorOffset();
    }

    public void renderArmor(GuiGraphics gui, int width, int height) {
        if (this.minecraft.options.hideGui) {
            return;
        }
        if (!InventoryHUD.armorHUD) {
            return;
        }
        if (this.debugEnabled() && !this.armorRenderer.withDebug) {
            return;
        }
        this.armorRenderer.render(gui, width, height);
        if (InventoryHUD.isCuriosMod && this.hasCuriosSlots()) {
            this.curiosRenderer.render(gui, width, height);
        }
    }

    public void renderPotions(GuiGraphics gui, int width, int height) {
        if (this.minecraft.options.hideGui) {
            return;
        }
        if (!InventoryHUD.potionHUD) {
            return;
        }
        if (this.debugEnabled() && !this.potionRenderer.withDebug) {
            return;
        }
        this.potionRenderer.render(gui, width, height);
    }

    public void renderInventory(GuiGraphics gui, int width, int height, DeltaTracker deltaTracker) {
        if (this.minecraft.options.hideGui) {
            return;
        }
        if (!InventoryHUD.isActive) {
            return;
        }
        if (this.debugEnabled() && !withDebug) {
            return;
        }
        if (this.minecraft.screen instanceof AbstractContainerScreen) {
            return;
        }
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        float scale = invMini ? 0.75f : 1.0f;
        int px = this.getX(width, (int)((float)(iMax * 18 - 2) * scale), invX, InventoryGui.InvAligns.HorAlign);
        int py = this.getY(height, (int)((float)(jMax * 18 - 2) * scale), invY, InventoryGui.InvAligns.VertAlign);
        ArrayList<Runnable> items = new ArrayList<Runnable>();
        PoseStack stack = gui.pose();
        int seed = 10;
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                ItemStack item = (ItemStack)this.minecraft.player.getInventory().items.get(index);
                if (item.isEmpty()) continue;
                int finalI = i;
                int finalJ = j;
                int finalSeed = seed++;
                items.add(() -> {
                    float f = (float)item.getPopTime() - deltaTracker.getGameTimeDeltaPartialTick(false);
                    stack.pushPose();
                    if (animated && f > 0.0f) {
                        stack.pushPose();
                        float f1 = 1.0f + f / 5.0f;
                        stack.translate((double)(finalI * 18 + 12), (double)(finalJ * 18 + 12), 0.0);
                        stack.scale((f1 + 1.0f) / 2.0f, (f1 + 1.0f) / 2.0f, 1.0f);
                        stack.translate((double)(-(finalI * 18 + 12)), (double)(-(finalJ * 18 + 12)), 0.0);
                    }
                    gui.renderItem((LivingEntity)this.minecraft.player, item, finalI * 18, finalJ * 18, finalSeed);
                    if (animated && f > 0.0f) {
                        stack.popPose();
                    }
                    gui.renderItemDecorations(this.minecraft.font, item, finalI * 18, finalJ * 18);
                    stack.popPose();
                });
            }
        }
        if (!items.isEmpty() || !hideBackground && invAlpha > 0.0f) {
            stack.pushPose();
            stack.translate((double)px, (double)py, -255.0);
            stack.scale(scale, scale, scale);
            if (invAlpha > 0.0f) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)invAlpha);
                gui.blit(INVBG, -8, -8, iMax * 18 + 14, jMax * 18 + 14, 0.0f, jMax == 3 ? 0.0f : 68.0f, iMax * 18 + 14, jMax * 18 + 14, 256, 256);
                RenderSystem.disableBlend();
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            items.forEach(Runnable::run);
            stack.popPose();
        }
    }

    public int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result = switch (hal) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.HAlign.LEFT -> x;
            case WidgetAligns.HAlign.MIDDLE -> width / 2 - itemWidth / 2 - x;
            case WidgetAligns.HAlign.RIGHT -> width - x;
        };
        return Mth.clamp((int)result, (int)0, (int)(width - itemWidth));
    }

    public int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result = switch (val) {
            default -> throw new MatchException(null, null);
            case WidgetAligns.VAlign.TOP -> y;
            case WidgetAligns.VAlign.CENTER -> height / 2 - itemHeight / 2 - y;
            case WidgetAligns.VAlign.BOTTOM -> height - y;
        };
        return Mth.clamp((int)result, (int)0, (int)(height - itemHeight));
    }

    public void changeArmorPos(WidgetAligns armal, int ax, int ay) {
        if (armal.HorAlign == WidgetAligns.HAlign.MIDDLE && armal.VertAlign == WidgetAligns.VAlign.BOTTOM && (float)ay <= 70.0f * this.armorRenderer.armScale + 5.0f && Math.abs(ax) <= 90) {
            if (!(this.armorRenderer instanceof HotBarArmorRenderer)) {
                this.armorRenderer = new HotBarArmorRenderer(this.minecraft);
                this.setupArmorRenderer();
            }
        } else if (this.armorRenderer instanceof HotBarArmorRenderer) {
            this.armorRenderer = new BlockArmorRenderer(this.minecraft);
            this.setupArmorRenderer();
        }
        this.armorRenderer.ArmAligns = armal;
        this.armorRenderer.armY = ay;
        this.armorRenderer.armX = ax;
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeArmorOffset() {
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeMoveAll(Boolean bd) {
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClientConfig().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClientConfig().armValign.get()));
        int armX = (Integer)InventoryHUD.getClientConfig().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClientConfig().yArmPos.get();
        this.armorRenderer = bd == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        this.setupArmorRenderer();
    }

    public void changePotionMini(boolean mini) {
        this.changePotion(mini, (Boolean)InventoryHUD.getClientConfig().potHor.get());
        this.setupPotionRenderer();
    }

    public void changePotionHor(boolean hor) {
        this.changePotion((Boolean)InventoryHUD.getClientConfig().potMini.get(), hor);
    }

    private void changePotion(boolean mini, boolean hor) {
        this.potionRenderer = hor ? (mini ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : (mini ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
    }

    public void resetBlackList() {
        this.potionRenderer.resetBlacklist();
    }

    public void disableCurios() {
        this.curiosRenderer.disable();
    }

    public HashMap<String, CuriosSlot> getCuriosSlots() {
        return this.curiosRenderer.slots();
    }

    public boolean hasCuriosSlots() {
        return !this.curiosRenderer.isEmpty();
    }

    private boolean debugEnabled() {
        return this.minecraft.gui.getDebugOverlay().showDebugScreen();
    }

    static {
        INVBG = ResourceLocation.tryBuild((String)"inventoryhud", (String)"textures/gui/inv_bg.png");
    }
}

