/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.CapybaraEntityAnimations;
import net.emilsg.clutterbestiary.entity.client.model.parent.ParentTameableModel;
import net.emilsg.clutterbestiary.entity.custom.CapybaraEntity;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.world.entity.LivingEntity;

public class CapybaraModel<T extends CapybaraEntity>
extends ParentTameableModel<T> {
    private final ModelPart all;
    private final ModelPart torso;
    private final ModelPart head;
    private final ModelPart root;

    public CapybaraModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
        this.torso = this.all.getChild("torso");
        this.head = this.torso.getChild("head");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)2.25f, (float)19.5f, (float)-4.5f));
        PartDefinition torso = all.addOrReplaceChild("torso", CubeListBuilder.create(), PartPose.offset((float)-2.25f, (float)4.5f, (float)3.5f));
        PartDefinition body = torso.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 16).addBox(-4.5f, -4.5f, -7.0f, 9.0f, 9.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 39).addBox(-4.5f, -4.5f, -7.0f, 9.0f, 5.0f, 14.0f, new CubeDeformation(0.125f)).texOffs(0, 61).addBox(-4.5f, 4.5f, -7.0f, 9.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 60).addBox(-4.5f, 4.5f, 7.0f, 9.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 49).addBox(-4.5f, 4.5f, -7.0f, 0.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)).texOffs(0, 48).addBox(4.5f, 4.5f, -7.0f, 0.0f, 1.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.5f, (float)1.0f));
        PartDefinition head = torso.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -3.0f, -7.5f, 6.0f, 6.0f, 9.0f, new CubeDeformation(0.0f)).texOffs(33, 23).addBox(-3.0f, -4.0f, -3.5f, 6.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-12.25f, (float)-5.5f));
        PartDefinition rightEar = head.addOrReplaceChild("rightEar", CubeListBuilder.create(), PartPose.offset((float)-2.5f, (float)-4.0f, (float)0.5f));
        PartDefinition rightEar_r1 = rightEar.addOrReplaceChild("rightEar_r1", CubeListBuilder.create().texOffs(49, 19).addBox(-2.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.4363f, (float)0.0f));
        PartDefinition leftEar = head.addOrReplaceChild("leftEar", CubeListBuilder.create(), PartPose.offset((float)2.5f, (float)-4.0f, (float)0.5f));
        PartDefinition leftEar_r1 = leftEar.addOrReplaceChild("leftEar_r1", CubeListBuilder.create().texOffs(33, 19).addBox(0.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)1.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f));
        PartDefinition frontRightLeg = torso.addOrReplaceChild("frontRightLeg", CubeListBuilder.create().texOffs(52, 0).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.25f, (float)-4.5f, (float)-3.5f));
        PartDefinition frontLeftLeg = torso.addOrReplaceChild("frontLeftLeg", CubeListBuilder.create().texOffs(40, 0).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.25f, (float)-4.5f, (float)-3.5f));
        PartDefinition backLeftLeg = torso.addOrReplaceChild("backLeftLeg", CubeListBuilder.create().texOffs(40, 8).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.25f, (float)-4.5f, (float)6.25f));
        PartDefinition backRightLeg = torso.addOrReplaceChild("backRightLeg", CubeListBuilder.create().texOffs(52, 8).addBox(-1.5f, -0.5f, -1.5f, 3.0f, 5.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.25f, (float)-4.5f, (float)6.25f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        if (this.young) {
            float babyScale = 0.5f;
            this.head.offsetScale(this.createVec3f(babyScale));
            matrices.pushPose();
            matrices.scale(babyScale, babyScale, babyScale);
            matrices.translate(0.0, 1.5, 0.0);
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
            this.head.offsetScale(this.createVec3f(0.9f));
        } else {
            matrices.pushPose();
            this.root().render(matrices, vertices, light, overlay, color);
            matrices.popPose();
        }
    }

    @Override
    public void setAngles(CapybaraEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        if (!entity.isSleeping() && !entity.isForceSleeping()) {
            this.setHeadAngles((LivingEntity)entity, netHeadYaw, headPitch, ageInTicks);
        }
        if (!entity.isMoving() && entity.isForceSleeping() || entity.isSleeping()) {
            this.animate(entity.sleepingAnimationState, entity.sleeperType() == 0 ? CapybaraEntityAnimations.CAPYBARA_LAY_DOWN_ONE : (entity.sleeperType() == 1 ? CapybaraEntityAnimations.CAPYBARA_LAY_DOWN_TWO : CapybaraEntityAnimations.CAPYBARA_LAY_DOWN_THREE), ageInTicks, 1.0f);
        } else {
            this.animateWalk(CapybaraEntityAnimations.CAPYBARA_WALK, limbSwing, limbSwingAmount, 1.5f, 2.0f);
        }
        this.animate(entity.earTwitchAnimationStateOne, CapybaraEntityAnimations.CAPYBARA_EAR_TWITCH_ONE, ageInTicks, 1.0f);
        this.animate(entity.earTwitchAnimationStateTwo, CapybaraEntityAnimations.CAPYBARA_EAR_TWITCH_TWO, ageInTicks, 1.0f);
    }

    @Override
    protected ModelPart getHeadPart() {
        return this.head;
    }
}

