/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.emilsg.clutterbestiary.entity.client.animation.JellyfishEntityAnimations;
import net.emilsg.clutterbestiary.entity.custom.JellyfishEntity;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class JellyfishModel<T extends JellyfishEntity>
extends HierarchicalModel<T> {
    private final ModelPart root;
    private final ModelPart all;

    public JellyfishModel(ModelPart root) {
        this.root = root;
        this.all = root.getChild("all");
    }

    public static LayerDefinition getTexturedModelData() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition all = modelPartData.addOrReplaceChild("all", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)27.0f, (float)0.0f));
        PartDefinition upperBody = all.addOrReplaceChild("upperBody", CubeListBuilder.create().texOffs(0, 10).addBox(-3.0f, -0.5f, -3.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-8.5f, (float)0.0f));
        PartDefinition lowerBody = all.addOrReplaceChild("lowerBody", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -1.0f, -4.0f, 8.0f, 2.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)-7.0f, (float)0.0f));
        PartDefinition outerTentacles = all.addOrReplaceChild("outerTentacles", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition frontTop = outerTentacles.addOrReplaceChild("frontTop", CubeListBuilder.create().texOffs(0, 26).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-4.0f));
        PartDefinition frontBottom = frontTop.addOrReplaceChild("frontBottom", CubeListBuilder.create().texOffs(0, 29).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition rightTop = outerTentacles.addOrReplaceChild("rightTop", CubeListBuilder.create().texOffs(16, 12).addBox(0.0f, 0.0f, -4.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)-6.0f, (float)0.0f));
        PartDefinition rightBottom = rightTop.addOrReplaceChild("rightBottom", CubeListBuilder.create().texOffs(16, 15).addBox(0.0f, 0.0f, -4.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition backTop = outerTentacles.addOrReplaceChild("backTop", CubeListBuilder.create().texOffs(16, 26).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)4.0f));
        PartDefinition backBottom = backTop.addOrReplaceChild("backBottom", CubeListBuilder.create().texOffs(16, 29).addBox(-4.0f, 0.0f, 0.0f, 8.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition leftTop = outerTentacles.addOrReplaceChild("leftTop", CubeListBuilder.create().texOffs(0, 12).addBox(0.0f, 0.0f, -4.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)-6.0f, (float)0.0f));
        PartDefinition leftBottom = leftTop.addOrReplaceChild("leftBottom", CubeListBuilder.create().texOffs(0, 15).addBox(0.0f, 0.0f, -4.0f, 0.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)3.0f, (float)0.0f));
        PartDefinition innerTentacles = all.addOrReplaceChild("innerTentacles", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition front = innerTentacles.addOrReplaceChild("front", CubeListBuilder.create().texOffs(52, 18).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)-3.0f));
        PartDefinition right = innerTentacles.addOrReplaceChild("right", CubeListBuilder.create().texOffs(35, 12).addBox(0.0f, 0.0f, -3.0f, 0.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-3.0f, (float)-5.0f, (float)0.0f));
        PartDefinition back = innerTentacles.addOrReplaceChild("back", CubeListBuilder.create().texOffs(35, 0).addBox(-3.0f, 0.0f, 0.0f, 6.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)3.0f));
        PartDefinition left = innerTentacles.addOrReplaceChild("left", CubeListBuilder.create().texOffs(52, -6).addBox(0.0f, 0.0f, -3.0f, 0.0f, 14.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)3.0f, (float)-5.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    public ModelPart root() {
        return this.root;
    }

    public void renderToBuffer(PoseStack matrices, VertexConsumer vertices, int light, int overlay, int color) {
        this.root().render(matrices, vertices, light, overlay, color);
    }

    public void setAngles(JellyfishEntity entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.animate(entity.swimmingAnimationState, JellyfishEntityAnimations.JELLYFISH_SWIM, animationProgress, 1.0f);
    }
}

