/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.emilsg.clutterbestiary.entity.client.layer.ModModelLayers;
import net.emilsg.clutterbestiary.entity.client.model.JellyfishModel;
import net.emilsg.clutterbestiary.entity.custom.JellyfishEntity;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class JellyfishRenderer
extends MobRenderer<JellyfishEntity, JellyfishModel<JellyfishEntity>> {
    public JellyfishRenderer(EntityRendererProvider.Context ctx) {
        super(ctx, new JellyfishModel(ctx.bakeLayer(ModModelLayers.JELLYFISH)), 0.4f);
    }

    @Nullable
    protected RenderType getRenderLayer(JellyfishEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.getRenderType((LivingEntity)entity, showBody, true, showOutline);
    }

    protected void setupTransforms(JellyfishEntity jellyfishEntity, PoseStack matrices, float animationProgress, float bodyYaw, float tickDelta, float scale) {
        super.setupRotations((LivingEntity)jellyfishEntity, matrices, animationProgress, bodyYaw, tickDelta, scale);
        float i = Mth.lerp((float)tickDelta, (float)jellyfishEntity.prevTiltAngle, (float)jellyfishEntity.tiltAngle);
        float j = Mth.lerp((float)tickDelta, (float)jellyfishEntity.prevRollAngle, (float)jellyfishEntity.rollAngle);
        matrices.translate(0.0f, 0.25f, 0.0f);
        matrices.mulPose(Axis.YP.rotationDegrees(180.0f - bodyYaw));
        matrices.mulPose(Axis.XP.rotationDegrees(i));
        matrices.mulPose(Axis.YP.rotationDegrees(j));
        matrices.translate(0.0f, 0.0f, 0.0f);
    }

    public ResourceLocation getTexture(JellyfishEntity entity) {
        return entity.getVariant().getTextureLocation();
    }
}

