/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.client.render.feature;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class EmissiveRenderer<E extends Entity, EM extends EntityModel<E>>
extends RenderLayer<E, EM> {
    private final Function<E, ResourceLocation> emissiveTextureProvider;

    public EmissiveRenderer(RenderLayerParent<E, EM> context, Function<E, ResourceLocation> emissiveTextureProvider) {
        super(context);
        this.emissiveTextureProvider = emissiveTextureProvider;
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, E entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        ResourceLocation emissiveTexture = this.emissiveTextureProvider.apply(entity);
        if (emissiveTexture == null) {
            return;
        }
        RenderType emissiveLayer = RenderType.eyes((ResourceLocation)emissiveTexture);
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(emissiveLayer);
        this.getParentModel().renderToBuffer(matrices, vertexConsumer, light, OverlayTexture.NO_OVERLAY);
    }
}

