/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.custom.goal.TamedEscapeDangerGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.sound.ModSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNetherNewtEntity
extends ParentTameableEntity
implements NeutralMob {
    private static final EntityDataAccessor<Integer> ANGER_TIME = SynchedEntityData.defineId(AbstractNetherNewtEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private static final EntityDataAccessor<Boolean> MOVING = SynchedEntityData.defineId(AbstractNetherNewtEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> SIZE = SynchedEntityData.defineId(AbstractNetherNewtEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> FUNGI = SynchedEntityData.defineId(AbstractNetherNewtEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> SITTING = SynchedEntityData.defineId(AbstractNetherNewtEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState sittingAnimationState = new AnimationState();
    int ticker = 6000;
    @Nullable
    private UUID angryAt;
    private int idleAnimationTimeout = 0;

    public AbstractNetherNewtEntity(EntityType<? extends ParentTameableEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER, -1.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, (double)0.3f).add(Attributes.ATTACK_DAMAGE, 3.0);
    }

    public void spawnChildFromBreeding(ServerLevel world, Animal other) {
        AbstractNetherNewtEntity netherNewtEntity = (AbstractNetherNewtEntity)this.getBreedOffspring(world, (AgeableMob)other);
        if (netherNewtEntity == null) {
            return;
        }
        float scaledSize = switch (this.random.nextInt(3) + 1) {
            case 2 -> 1.0f;
            case 3 -> 1.25f;
            default -> 0.85f;
        };
        netherNewtEntity.setBaby(true);
        netherNewtEntity.setNewtSize(scaledSize);
        netherNewtEntity.moveTo(this.getX(), this.getY(), this.getZ(), 0.0f, 0.0f);
        netherNewtEntity.setFungiCount(this.random.nextInt(5) + 1);
        this.finalizeSpawnChildFromBreeding(world, other, (AgeableMob)netherNewtEntity);
        world.addFreshEntityWithPassengers((Entity)netherNewtEntity);
    }

    protected void playHurtSound(DamageSource source) {
        super.playHurtSound(source);
    }

    public boolean canMate(Animal other) {
        if (other == this) {
            return false;
        }
        if (!this.isTame()) {
            return false;
        }
        if (!(other instanceof AbstractNetherNewtEntity)) {
            return false;
        }
        AbstractNetherNewtEntity netherNewtEntity = (AbstractNetherNewtEntity)other;
        if (!netherNewtEntity.isTame()) {
            return false;
        }
        if (netherNewtEntity.isInSittingPose()) {
            return false;
        }
        return this.isInLove() && netherNewtEntity.isInLove();
    }

    @Override
    @Nullable
    public abstract AgeableMob getBreedOffspring(ServerLevel var1, AgeableMob var2);

    public float getVoicePitch() {
        float multiplier = this.getNewtSize() > 1.0f ? 1.05f : 1.2f;
        return this.isBaby() ? ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.5f) * multiplier : ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * multiplier;
    }

    public boolean checkSpawnObstruction(LevelReader world) {
        return world.isUnobstructed((Entity)this);
    }

    public boolean checkSpawnRules(LevelAccessor world, MobSpawnType spawnReason) {
        return true;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(ANGER_TIME_RANGE.sample(this.random));
    }

    public boolean isOrderedToSit() {
        return (Boolean)this.entityData.get(SITTING);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.readPersistentAngerSaveData(this.level(), nbt);
        this.setNewtSize(nbt.getFloat("Size"));
        this.setFungiCount(nbt.getInt("Fungi"));
        this.entityData.set(SITTING, (Object)nbt.getBoolean("isSitting"));
    }

    public void setSit(boolean sitting) {
        this.entityData.set(SITTING, (Object)sitting);
        super.setOrderedToSit(sitting);
        this.navigation.stop();
    }

    public void setNewtSize(float size) {
        this.entityData.set(SIZE, (Object)Float.valueOf(size));
        Objects.requireNonNull(this.getAttribute(Attributes.SCALE)).setBaseValue((double)size);
        this.reapplyPosition();
        this.refreshDimensions();
    }

    public int getRemainingPersistentAngerTime() {
        return (Integer)this.entityData.get(ANGER_TIME);
    }

    public void setRemainingPersistentAngerTime(int angerTime) {
        this.entityData.set(ANGER_TIME, (Object)angerTime);
    }

    @Nullable
    public UUID getPersistentAngerTarget() {
        return this.angryAt;
    }

    public void setPersistentAngerTarget(@Nullable UUID angryAt) {
        this.angryAt = angryAt;
    }

    public abstract Item getBreedingItem();

    @Nullable
    public abstract Holder<MobEffect> getOnAttackEffect();

    public int getFungiCount() {
        return (Integer)this.entityData.get(FUNGI);
    }

    public void setFungiCount(int count) {
        this.entityData.set(FUNGI, (Object)Mth.clamp((int)count, (int)0, (int)5));
    }

    public float getNewtSize() {
        return ((Float)this.entityData.get(SIZE)).floatValue();
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        this.addPersistentAngerSaveData(nbt);
        nbt.putFloat("Size", this.getNewtSize());
        nbt.putInt("Fungi", this.getFungiCount());
        nbt.putBoolean("isSitting", ((Boolean)this.entityData.get(SITTING)).booleanValue());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        this.setNewtSize(switch (this.random.nextInt(3) + 1) {
            case 2 -> 1.0f;
            case 3 -> 1.25f;
            default -> 0.85f;
        });
        this.reapplyPosition();
        this.refreshDimensions();
        this.setFungiCount(this.random.nextInt(5) + 1);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack stackInHand = player.getItemInHand(hand);
        Level world = this.level();
        BlockPos pos = this.blockPosition();
        int fungiCount = this.getFungiCount();
        if (stackInHand.getItem() instanceof ShearsItem && !world.isClientSide && fungiCount != 0) {
            if (!player.getAbilities().instabuild) {
                stackInHand.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            }
            this.spawnAtLocation(new ItemStack((ItemLike)this.getFungusItem(), fungiCount));
            world.playSound(null, pos, SoundEvents.GROWING_PLANT_CROP, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.setFungiCount(0);
            return InteractionResult.SUCCESS;
        }
        if (this.isFood(stackInHand) && this.getHealth() < this.getMaxHealth()) {
            FoodProperties foodComponent;
            if (!player.getAbilities().instabuild) {
                stackInHand.consume(1, (LivingEntity)player);
            }
            float nutrition = (foodComponent = (FoodProperties)stackInHand.get(DataComponents.FOOD)) != null ? (float)foodComponent.nutrition() : 1.0f;
            this.heal(2.0f * nutrition);
            return InteractionResult.SUCCESS;
        }
        if (this.isTamingItem(stackInHand) && !this.isTame()) {
            this.playSound(SoundEvents.STRIDER_EAT, 1.0f, 1.5f);
            if (this.level().isClientSide()) {
                return InteractionResult.CONSUME;
            }
            if (!player.getAbilities().instabuild) {
                stackInHand.shrink(1);
            }
            if (this.random.nextInt(3) == 0 && !this.level().isClientSide()) {
                super.tame(player);
                this.navigation.recomputePath();
                this.setHealth(this.getMaxHealth());
                this.setTame(true, true);
                this.setTarget(null);
                this.level().broadcastEntityEvent((Entity)this, (byte)7);
                this.setSit(true);
            } else {
                this.level().broadcastEntityEvent((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        if (this.isTame() && !this.level().isClientSide() && hand == InteractionHand.MAIN_HAND && this.isOwnedBy((LivingEntity)player) && !this.isFood(stackInHand)) {
            this.setSit(!this.isOrderedToSit());
            return InteractionResult.SUCCESS;
        }
        return super.mobInteract(player, hand);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return ModSoundEvents.ENTITY_NETHER_NEWT_AMBIENT.get();
    }

    protected abstract Item getTamingItem();

    @Override
    public boolean isFood(ItemStack stack) {
        return stack.is(this.getBreedingItem());
    }

    @Override
    public boolean isMoving() {
        return (Boolean)this.entityData.get(MOVING);
    }

    @Override
    public void setMoving(boolean moving) {
        this.entityData.set(MOVING, (Object)moving);
    }

    public boolean isAngryAtAllPlayers(Level world) {
        return world.getGameRules().getBoolean(GameRules.RULE_UNIVERSAL_ANGER) && this.isAngry() && this.getPersistentAngerTarget() == null;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(ANGER_TIME, (Object)0);
        builder.define(SIZE, (Object)Float.valueOf(1.0f));
        builder.define(MOVING, (Object)false);
        builder.define(FUNGI, (Object)1);
        builder.define(SITTING, (Object)false);
    }

    public void setBaby(boolean baby) {
        this.setNewtSize(switch (this.random.nextInt(3) + 1) {
            case 2 -> 1.25f;
            case 3 -> 1.5f;
            default -> 1.0f;
        });
        this.setFungiCount(this.random.nextInt(5) + 1);
        super.setBaby(baby);
    }

    public boolean isAngryAt(LivingEntity entity) {
        if (!this.canAttack(entity)) {
            return false;
        }
        return entity.getType() == EntityType.PLAYER && this.isAngryAtAllPlayers(entity.level()) || entity.getUUID().equals(this.getPersistentAngerTarget());
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (!world.isClientSide) {
            --this.ticker;
            if (this.ticker <= 0 && this.getFungiCount() != 5) {
                this.setFungiCount(this.getFungiCount() + 1);
                this.ticker = 6000;
            }
        }
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (!this.level().isClientSide) {
            BlockPos newPos;
            BlockPos oldPos = this.blockPosition();
            this.setMoving(oldPos != (newPos = this.blockPosition()));
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(2, (Goal)new TamedEscapeDangerGoal(this, 1.5));
        this.goalSelector.addGoal(2, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.goalSelector.addGoal(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.goalSelector.addGoal(4, (Goal)new BreedGoal((Animal)this, (double)1.2f));
        this.goalSelector.addGoal(5, (Goal)new TemptGoal((PathfinderMob)this, (double)1.2f, (Predicate)this.getBreedingIngredient(), false));
        this.goalSelector.addGoal(6, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.2, 10.0f, 2.0f));
        this.goalSelector.addGoal(7, (Goal)new FollowParentGoal((Animal)this, (double)1.2f));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.targetSelector.addGoal(3, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    protected void applyTamingSideEffects() {
        Objects.requireNonNull(this.getAttribute(Attributes.MAX_HEALTH)).setBaseValue(20.0);
        Objects.requireNonNull(this.getAttribute(Attributes.ATTACK_DAMAGE)).setBaseValue(6.0);
    }

    protected abstract Item getFungusItem();

    @Nullable
    protected SoundEvent getHurtSound(DamageSource source) {
        return ModSoundEvents.ENTITY_NETHER_NEWT_HURT.get();
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
        SoundType blockSoundGroup = state.getSoundType();
        this.playSound(blockSoundGroup.getStepSound(), blockSoundGroup.getVolume() * 0.05f, blockSoundGroup.getPitch());
    }

    private boolean isTamingItem(ItemStack itemStack) {
        return itemStack.is(this.getTamingItem());
    }

    protected void updateWalkAnimation(float v) {
        float f = this.getPose() == Pose.STANDING ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.walkAnimation.update(f, 0.2f);
    }

    private Ingredient getBreedingIngredient() {
        return Ingredient.of((ItemLike[])new ItemLike[]{this.getBreedingItem()});
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0 && !this.isMoving()) {
            this.idleAnimationTimeout = 80;
            this.idleAnimationState.start(this.tickCount);
        } else {
            --this.idleAnimationTimeout;
        }
        if (this.isOrderedToSit() && !this.sittingAnimationState.isStarted()) {
            this.sittingAnimationState.start(this.tickCount);
        } else if (!this.isOrderedToSit()) {
            this.sittingAnimationState.stop();
        }
    }
}

