/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.goal.DragonflyFastWanderGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.DragonflyHoverLilypadGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.EscapeWaterGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.HoverGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentAnimalEntity;
import net.emilsg.clutterbestiary.entity.variants.DragonflyVariant;
import net.emilsg.clutterbestiary.entity.variants.SeahorseVariant;
import net.emilsg.clutterbestiary.util.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DragonflyEntity
extends ParentAnimalEntity {
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(DragonflyEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public final AnimationState flyingAnimState = new AnimationState();
    private int animationTimeout = 0;

    public DragonflyEntity(EntityType<? extends ParentAnimalEntity> entityType, Level world) {
        super(entityType, world);
        this.moveControl = new SnappyFlightMoveControl((Mob)this);
        this.lookControl = new DragonflyLookControl((Mob)this);
        this.setNoGravity(true);
        this.setPathfindingMalus(PathType.DANGER_FIRE, -1.0f);
        this.setPathfindingMalus(PathType.WATER, -2.0f);
        this.setPathfindingMalus(PathType.WATER_BORDER, 16.0f);
        this.setPathfindingMalus(PathType.COCOA, -1.0f);
        this.setPathfindingMalus(PathType.FENCE, -1.0f);
    }

    public static AttributeSupplier.Builder setAttributes() {
        return ParentAnimalEntity.createMobAttributes().add(Attributes.MAX_HEALTH, 8.0).add(Attributes.FLYING_SPEED, 3.0).add(Attributes.MOVEMENT_SPEED, (double)0.1f).add(Attributes.FOLLOW_RANGE, 16.0);
    }

    public DragonflyVariant getVariant() {
        return DragonflyVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(DragonflyVariant variant) {
        this.entityData.set(VARIANT, (Object)variant.getId());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType spawnReason, @Nullable SpawnGroupData entityData) {
        DragonflyVariant variant = DragonflyVariant.getRandom();
        this.setVariant(variant);
        return super.finalizeSpawn(world, difficulty, spawnReason, entityData);
    }

    public static boolean isValidNaturalSpawn(EntityType<? extends Animal> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBlockState(pos.below()).is(ModBlockTags.DRAGONFLIES_SPAWN_ON);
    }

    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.entityData.set(VARIANT, (Object)nbt.getString("Variant"));
    }

    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putString("Variant", this.getTypeVariant());
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return false;
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)((EntityType)ModEntityTypes.DRAGONFLY.get()).create((Level)world);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)SeahorseVariant.YELLOW.getId());
    }

    public float getWalkTargetValue(BlockPos pos, LevelReader world) {
        return world.getBlockState(pos).isAir() ? 10.0f : 0.0f;
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new EscapeWaterGoal(this));
        this.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 8.0f, 1.0, (double)1.2f));
        this.goalSelector.addGoal(2, (Goal)new DragonflyHoverLilypadGoal(this));
        this.goalSelector.addGoal(3, (Goal)new HoverGoal(this));
        this.goalSelector.addGoal(3, (Goal)new DragonflyFastWanderGoal(this));
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public void tick() {
        super.tick();
        Level world = this.level();
        if (world.isClientSide) {
            this.setupAnimationStates();
        }
    }

    protected PathNavigation createNavigation(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation(this, (Mob)this, world){

            public boolean isStableDestination(BlockPos pos) {
                return this.level.getBlockState(pos.below()).isAir();
            }
        };
        birdNavigation.setCanOpenDoors(false);
        birdNavigation.setCanFloat(false);
        birdNavigation.setCanPassDoors(true);
        return birdNavigation;
    }

    protected void checkFallDamage(double heightDifference, boolean onGround, BlockState state, BlockPos landedPosition) {
    }

    private String getTypeVariant() {
        return (String)this.entityData.get(VARIANT);
    }

    protected void playStepSound(BlockPos pos, BlockState state) {
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 20;
            this.flyingAnimState.start(this.tickCount);
        } else {
            --this.animationTimeout;
        }
    }

    public static class SnappyFlightMoveControl
    extends MoveControl {
        private final Mob mob;
        private final float multiplier = 0.05f;

        public SnappyFlightMoveControl(Mob mob) {
            super(mob);
            this.mob = mob;
        }

        public void tick() {
            if (this.operation != MoveControl.Operation.MOVE_TO) {
                return;
            }
            Vec3 to = new Vec3(this.wantedX - this.mob.getX(), this.wantedY - this.mob.getY(), this.wantedZ - this.mob.getZ());
            if (to.lengthSqr() < 0.01) {
                this.operation = MoveControl.Operation.WAIT;
                return;
            }
            Vec3 dir = to.normalize();
            double boost = this.speedModifier * (double)0.05f;
            this.mob.setDeltaMovement(this.mob.getDeltaMovement().scale(0.6).add(dir.scale(boost)));
            this.mob.setYRot((float)(Mth.atan2((double)dir.z, (double)dir.x) * 57.29577951308232) - 90.0f);
            this.mob.yBodyRot = this.mob.getYRot();
        }
    }

    private static class DragonflyLookControl
    extends LookControl {
        DragonflyLookControl(Mob entity) {
            super(entity);
        }

        public void tick() {
            super.tick();
        }

        protected boolean resetXRotOnTick() {
            return true;
        }
    }
}

