/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import net.emilsg.clutterbestiary.entity.custom.DragonflyEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class DragonflyHoverLilypadGoal
extends Goal {
    private final DragonflyEntity dragonFly;
    private final int scanRadius = 16;
    private final double approachSpeed = 1.8;
    private final int scanEvery = 20;
    private final int samples = 48;
    private final BlockPos.MutableBlockPos m = new BlockPos.MutableBlockPos();
    private final BlockPos.MutableBlockPos above = new BlockPos.MutableBlockPos();
    private BlockPos pad;
    private int hoverTicks;
    private int nextScan;

    public DragonflyHoverLilypadGoal(DragonflyEntity dragonFly) {
        this.dragonFly = dragonFly;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.nextScan > 0) {
            --this.nextScan;
            return false;
        }
        this.nextScan = 20;
        if (this.dragonFly.getRandom().nextInt(6) != 0) {
            return false;
        }
        Level world = this.dragonFly.level();
        BlockPos origin = this.dragonFly.blockPosition();
        BlockPos best = null;
        double bestSq = Double.MAX_VALUE;
        for (int i = 0; i < 48; ++i) {
            double dsq;
            int dx = this.dragonFly.getRandom().nextIntBetweenInclusive(-16, 16);
            int dz = this.dragonFly.getRandom().nextIntBetweenInclusive(-16, 16);
            int dy = this.dragonFly.getRandom().nextIntBetweenInclusive(-2, 3);
            this.m.set(origin.getX() + dx, origin.getY() + dy, origin.getZ() + dz);
            if (!world.getBlockState((BlockPos)this.m).is(Blocks.LILY_PAD)) continue;
            this.above.set(this.m.getX(), this.m.getY() + 1, this.m.getZ());
            if (!world.getBlockState((BlockPos)this.above).isAir() || !((dsq = this.above.distToCenterSqr((Position)this.dragonFly.position())) < bestSq)) continue;
            bestSq = dsq;
            best = this.m.immutable();
            if (dsq < 9.0) break;
        }
        if (best != null) {
            this.pad = best;
            this.hoverTicks = this.dragonFly.getRandom().nextIntBetweenInclusive(40, 80);
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        if (this.hoverTicks <= 0 || this.pad == null) {
            return false;
        }
        return this.dragonFly.level().getBlockState(this.pad).is(Blocks.LILY_PAD);
    }

    public void start() {
        if (this.pad != null) {
            Vec3 tgt = this.pad.getCenter().add(0.0, 0.6, 0.0);
            this.dragonFly.getNavigation().moveTo(tgt.x, tgt.y, tgt.z, 1.8);
        }
    }

    public void stop() {
        this.pad = null;
        this.hoverTicks = 0;
    }

    public void tick() {
        if (this.pad == null) {
            return;
        }
        Vec3 target = this.pad.getCenter().add(0.0, 0.6, 0.0);
        Vec3 to = target.subtract(this.dragonFly.position());
        double dist = to.length();
        if (dist > 0.9) {
            if ((this.dragonFly.tickCount & 3) == 0) {
                this.dragonFly.getNavigation().moveTo(target.x, target.y, target.z, 1.8);
            }
            Vec3 dir = to.normalize();
            this.dragonFly.setDeltaMovement(this.dragonFly.getDeltaMovement().scale(0.6).add(dir.scale(0.16)));
        } else {
            double bob = Math.sin((double)this.dragonFly.tickCount * 0.3) * 0.015;
            double jitter = (this.dragonFly.getRandom().nextDouble() - 0.5) * 0.02;
            Vec3 hold = target.add(jitter, bob, jitter).subtract(this.dragonFly.position()).scale(0.14);
            this.dragonFly.setDeltaMovement(this.dragonFly.getDeltaMovement().scale(0.7).add(hold));
        }
        this.dragonFly.getLookControl().setLookAt(target);
        --this.hoverTicks;
    }
}

