/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.EmberTortoiseEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.pathfinder.Path;

public class EmberTortoiseMeleeGoal
extends MeleeAttackGoal {
    private final EmberTortoiseEntity entity;
    private final double speed;
    private int attackDelay = 20;
    private Path path;
    private int updateCountdownTicks;
    private int cooldown;
    private long lastUpdateTime;
    private int ticksUntilNextAttack = 20;
    private boolean shouldCountTillNextAttack = false;

    public EmberTortoiseMeleeGoal(PathfinderMob mob, double speed, boolean pauseWhenMobIdle) {
        super(mob, speed, pauseWhenMobIdle);
        this.entity = (EmberTortoiseEntity)mob;
        this.speed = speed;
    }

    public boolean canUse() {
        return !this.entity.isShielding() && this.startAttack();
    }

    public void start() {
        this.mob.getNavigation().moveTo(this.path, this.speed);
        this.mob.setAggressive(true);
        this.updateCountdownTicks = 0;
        this.cooldown = 0;
        this.attackDelay = 20;
        this.ticksUntilNextAttack = 20;
    }

    public void stop() {
        this.entity.setAggressive(false);
        super.stop();
    }

    public void tick() {
        if (this.entity.isShielding()) {
            this.resetAttackCooldown();
            this.entity.setAggressive(false);
            this.stop();
            return;
        }
        super.tick();
        if (this.shouldCountTillNextAttack) {
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
        }
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        if (this.entity.isShielding()) {
            this.entity.getNavigation().stop();
            this.resetAttackCooldown();
            this.entity.setAggressive(false);
            return;
        }
        if (this.isEnemyWithinAttackDistance(target)) {
            this.shouldCountTillNextAttack = true;
            if (this.isTimeToStartAttackAnimation()) {
                this.entity.setAggressive(true);
            }
            if (this.isTimeToAttack()) {
                this.mob.getLookControl().setLookAt(target.getX(), target.getEyeY(), target.getZ());
                this.performAttack(target);
            }
        } else {
            this.resetAttackCooldown();
            this.shouldCountTillNextAttack = false;
            this.entity.setAggressive(false);
            this.entity.attackAnimationTimeout = 0;
        }
    }

    protected boolean isTimeToAttack() {
        return this.ticksUntilNextAttack <= 0;
    }

    protected boolean isTimeToStartAttackAnimation() {
        return this.ticksUntilNextAttack <= this.attackDelay;
    }

    protected void performAttack(LivingEntity pEnemy) {
        this.resetAttackCooldown();
        this.mob.swing(InteractionHand.MAIN_HAND);
        this.mob.doHurtTarget((Entity)pEnemy);
    }

    protected void resetAttackCooldown() {
        this.ticksUntilNextAttack = this.adjustedTickDelay(this.attackDelay * 2);
    }

    private boolean isEnemyWithinAttackDistance(LivingEntity pEnemy) {
        return this.mob.distanceToSqr((Entity)pEnemy) < 8.0;
    }

    private boolean startAttack() {
        long l = this.mob.level().getGameTime();
        if (l - this.lastUpdateTime < 20L) {
            return false;
        }
        this.lastUpdateTime = l;
        LivingEntity livingEntity = this.mob.getTarget();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.isAlive()) {
            return false;
        }
        this.path = this.mob.getNavigation().createPath((Entity)livingEntity, 1);
        if (this.path != null) {
            return true;
        }
        return 3.0 >= this.mob.distanceToSqr(livingEntity.getX(), livingEntity.getY(), livingEntity.getZ());
    }
}

