/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import java.util.EnumSet;
import net.emilsg.clutterbestiary.entity.custom.JellyfishEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.ai.goal.Goal;

public class JellyfishAvoidSurfaceGoal
extends Goal {
    private final JellyfishEntity jellyfish;

    public JellyfishAvoidSurfaceGoal(JellyfishEntity jellyfish) {
        this.jellyfish = jellyfish;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (!this.jellyfish.isInWaterOrBubble()) {
            return false;
        }
        double surfaceY = this.jellyfish.level().getMaxBuildHeight();
        BlockPos pos = this.jellyfish.blockPosition();
        for (int i = 0; i < 3; ++i) {
            BlockPos check = pos.above(i);
            if (!this.jellyfish.level().getBlockState(check).getFluidState().isEmpty()) continue;
            surfaceY = check.getY();
            break;
        }
        return surfaceY - this.jellyfish.getY() < 1.0;
    }

    public void tick() {
        this.jellyfish.setSwimmingVector(this.jellyfish.getSwimX(), -0.2f, this.jellyfish.getSwimZ());
    }
}

