/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.KiwiBirdEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class KiwiBirdLayEggGoal
extends MoveToBlockGoal {
    KiwiBirdEntity kiwiBird;
    BlockState eggState;

    public KiwiBirdLayEggGoal(KiwiBirdEntity kiwiBird, double speed, BlockState eggState) {
        super((PathfinderMob)kiwiBird, speed, 16);
        this.kiwiBird = kiwiBird;
        this.eggState = eggState;
    }

    public boolean canUse() {
        return this.kiwiBird.hasEgg() && super.canUse() && this.kiwiBird.getEggTimer() >= 400 && !this.kiwiBird.isDancing();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.kiwiBird.hasEgg() && this.kiwiBird.getEggTimer() >= 400;
    }

    public void tick() {
        super.tick();
        if (this.isReachedTarget()) {
            Level world = this.kiwiBird.level();
            world.setBlock(this.blockPos.above(), this.eggState, 3);
            world.gameEvent((Holder)GameEvent.BLOCK_PLACE, this.blockPos.above(), GameEvent.Context.of((Entity)this.kiwiBird, (BlockState)this.eggState));
            this.kiwiBird.setHasEgg(false);
            this.kiwiBird.setEggTimer(0);
        }
    }

    protected boolean isValidTarget(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return !(!world.isEmptyBlock(pos.above()) && !world.getBlockState(pos.above()).canBeReplaced() || !state.is(BlockTags.DIRT) && !state.is(Blocks.HAY_BLOCK) || world.getFluidState(pos.above()).is((Fluid)Fluids.WATER));
    }
}

