/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;

public enum PotionWaspVariant {
    REGENERATION("regeneration", (Holder<Potion>)Potions.REGENERATION),
    POISON("poison", (Holder<Potion>)Potions.POISON),
    STRENGTH("strength", (Holder<Potion>)Potions.STRENGTH),
    SWIFTNESS("swiftness", (Holder<Potion>)Potions.SWIFTNESS),
    WEAKNESS("weakness", (Holder<Potion>)Potions.WEAKNESS);

    private final String name;
    private final Holder<Potion> effect;

    private PotionWaspVariant(String name, Holder<Potion> effect) {
        this.name = name;
        this.effect = effect;
    }

    public static PotionWaspVariant fromId(String id) {
        return Arrays.stream(PotionWaspVariant.values()).filter(v -> v.getId().equals(id)).findFirst().orElse(REGENERATION);
    }

    public static PotionWaspVariant getRandom() {
        List<PotionWaspVariant> variants = Arrays.stream(PotionWaspVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    public static List<Holder<MobEffect>> getAllStatusEffects() {
        return Arrays.stream(PotionWaspVariant.values()).map(PotionWaspVariant::getPotionEffect).map(Holder::value).flatMap(potion -> potion.getEffects().stream()).map(MobEffectInstance::getEffect).distinct().toList();
    }

    public String getId() {
        return "clutterbestiary:" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public Holder<Potion> getPotionEffect() {
        return this.effect;
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/potion_wasp/" + this.getName() + "_potion_wasp.png"));
    }
}

