/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.Objects;
import java.util.UUID;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.ButterflyEntity;
import net.emilsg.clutterbestiary.entity.custom.goal.TamedEscapeDangerGoal;
import net.emilsg.clutterbestiary.entity.custom.goal.WanderAroundFarOftenGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentTameableEntity;
import net.emilsg.clutterbestiary.item.ModItems;
import net.emilsg.clutterbestiary.item.custom.ButterflyBottleItem;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1353;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1400;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class ChameleonEntity
extends ParentTameableEntity {
    private static final class_1856 BREEDING_INGREDIENT;
    private static final class_2940<Boolean> SITTING;
    private static final class_2940<Boolean> ATTACKING;
    private int currentColor = 9487484;
    private int targetColor = 9487484;
    private int retainColorChangeTimer = 0;
    private int colorTicker = 0;
    public final class_7094 tailIdleAnimationState = new class_7094();
    public final class_7094 toungeIdleAnimationState = new class_7094();
    public int tailIdleAnimationTimeout = 0;
    public int toungeIdleAnimationTimeout = 0;
    public final class_7094 sittingAnimationState = new class_7094();

    private void setupAnimationStates() {
        if (this.tailIdleAnimationTimeout <= 0 && !this.isMoving()) {
            this.tailIdleAnimationTimeout = 40;
            this.tailIdleAnimationState.method_41322(this.field_6012);
        } else {
            --this.tailIdleAnimationTimeout;
        }
        if (this.toungeIdleAnimationTimeout <= 0) {
            this.toungeIdleAnimationTimeout = 20 + (this.field_5974.method_43048(5) + 3) * 100;
            this.toungeIdleAnimationState.method_41322(this.field_6012);
        } else {
            --this.toungeIdleAnimationTimeout;
        }
        if (this.method_24345() && !this.sittingAnimationState.method_41327()) {
            this.sittingAnimationState.method_41322(this.field_6012);
        } else if (!this.method_24345()) {
            this.sittingAnimationState.method_41325();
        }
    }

    public boolean method_6510() {
        return (Boolean)this.field_6011.method_12789(ATTACKING);
    }

    public void method_19540(boolean attacking) {
        this.field_6011.method_12778(ATTACKING, (Object)attacking);
    }

    public int getCurrentColor() {
        return this.currentColor;
    }

    public int getTargetColor() {
        return this.targetColor;
    }

    public void setTargetColor(int color) {
        this.targetColor = color;
    }

    public ChameleonEntity(class_1299<? extends ParentTameableEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1429.method_26828().method_26868(class_5134.field_23716, 6.0).method_26868(class_5134.field_23719, (double)0.18f).method_26868(class_5134.field_23723, 1.0).method_26868(class_5134.field_23722, (double)0.1f).method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23717, 16.0);
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f * 2.75f, 0.2f);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        class_1792 item = stackInHand.method_7909();
        class_1792 itemForTaming = class_1802.field_8279;
        if (this.method_6481(stackInHand) && this.method_6032() < this.method_6063()) {
            if (!player.method_31549().field_7477) {
                stackInHand.method_7934(1);
            }
            this.method_6025(Objects.requireNonNull(item.method_19264()).method_19230());
            return class_1269.field_5812;
        }
        if (item == itemForTaming && !this.method_6181()) {
            this.method_5783(class_3417.field_37315, 1.0f, 1.25f);
            if (this.method_37908().method_8608()) {
                return class_1269.field_21466;
            }
            if (!player.method_31549().field_7477) {
                stackInHand.method_7934(1);
            }
            if (this.field_5974.method_43048(3) == 0 && !this.method_37908().method_8608()) {
                super.method_6170(player);
                this.field_6189.method_6356();
                this.method_6033(this.method_6063());
                this.method_5980(null);
                this.method_37908().method_8421((class_1297)this, (byte)7);
                this.setSit(true);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
            return class_1269.field_5812;
        }
        if (this.method_6181() && !this.method_37908().method_8608() && hand == class_1268.field_5808 && !(stackInHand.method_7909() instanceof ButterflyBottleItem) && this.method_6171((class_1309)player)) {
            this.setSit(!this.method_24345());
            return class_1269.field_5812;
        }
        if (stackInHand.method_7909() == itemForTaming) {
            return class_1269.field_5811;
        }
        return super.method_5992(player, hand);
    }

    public void method_24650(class_3218 world, class_1429 other) {
        super.method_24650(world, other);
    }

    public boolean method_5931(class_1657 player) {
        return !this.method_24345() && this.method_6171((class_1309)player);
    }

    public boolean method_6474(class_1429 other) {
        if (other == this) {
            return false;
        }
        if (!this.method_6181()) {
            return false;
        }
        if (!(other instanceof ChameleonEntity)) {
            return false;
        }
        ChameleonEntity chameleonEntity = (ChameleonEntity)other;
        if (!chameleonEntity.method_6181()) {
            return false;
        }
        if (chameleonEntity.method_6172()) {
            return false;
        }
        return this.method_6479() && chameleonEntity.method_6479();
    }

    @Nullable
    public ChameleonEntity createChild(class_3218 serverWorld, class_1296 passiveEntity) {
        UUID uUID;
        ChameleonEntity chameleonEntity = (ChameleonEntity)ModEntityTypes.CHAMELEON.method_5883((class_1937)serverWorld);
        if (chameleonEntity != null && (uUID = this.method_6139()) != null) {
            chameleonEntity.method_6174(uUID);
            chameleonEntity.method_6173(true);
        }
        return chameleonEntity;
    }

    public double method_5621() {
        return 0.15;
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
            boolean hasNearbyEntity = !world.method_8333((class_1297)this, this.method_5829().method_1014(6.0), entity -> entity != null && entity != this && this.method_35057() != entity && !(entity instanceof ChameleonEntity) && !entity.method_5715()).isEmpty();
            this.method_19540(hasNearbyEntity);
            this.updateColorTransition(hasNearbyEntity);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_7909() instanceof ButterflyBottleItem;
    }

    public boolean method_24345() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(SITTING, (Object)nbt.method_10577("isSitting"));
    }

    public void setSit(boolean sitting) {
        this.field_6011.method_12778(SITTING, (Object)sitting);
        super.method_24346(sitting);
    }

    public void method_6173(boolean tamed) {
        super.method_6173(tamed);
        if (tamed) {
            this.method_5996(class_5134.field_23716).method_6192(18.0);
            this.method_5996(class_5134.field_23721).method_6192(6.0);
        } else {
            this.method_5996(class_5134.field_23716).method_6192(6.0);
            this.method_5996(class_5134.field_23721).method_6192(3.0);
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(3, (class_1352)new TamedEscapeDangerGoal(this, 1.5));
        this.field_6201.method_6277(4, (class_1352)new class_1350((class_1321)this, 1.2, 10.0f, 2.0f, false));
        this.field_6201.method_6277(5, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 1.2, BREEDING_INGREDIENT, false));
        this.field_6201.method_6277(7, (class_1352)new class_1353((class_1429)this, 1.2));
        this.field_6201.method_6277(8, (class_1352)new class_1359((class_1308)this, 0.5f));
        this.field_6201.method_6277(9, (class_1352)new class_1366((class_1314)this, 1.0, true));
        this.field_6201.method_6277(10, (class_1352)new WanderAroundFarOftenGoal((class_1314)this, 1.0f));
        this.field_6201.method_6277(11, (class_1352)new class_1361((class_1308)this, class_1657.class, 6.0f));
        this.field_6201.method_6277(12, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, ButterflyEntity.class, true));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10556("isSitting", ((Boolean)this.field_6011.method_12789(SITTING)).booleanValue());
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 landedPosition) {
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SITTING, (Object)false);
        this.field_6011.method_12784(ATTACKING, (Object)false);
    }

    private void updateColorTransition(boolean shouldChangeColor) {
        ++this.colorTicker;
        if (this.colorTicker % 2 == 0) {
            if (shouldChangeColor) {
                this.retainColorChangeTimer = 200;
            }
            if (this.retainColorChangeTimer > 0) {
                --this.retainColorChangeTimer;
                int r1 = this.currentColor >> 16 & 0xFF;
                int g1 = this.currentColor >> 8 & 0xFF;
                int b1 = this.currentColor & 0xFF;
                int r2 = this.targetColor >> 16 & 0xFF;
                int g2 = this.targetColor >> 8 & 0xFF;
                int b2 = this.targetColor & 0xFF;
                float lerpSpeed = 0.5f;
                int r = (int)((float)r1 + (float)(r2 - r1) * lerpSpeed);
                int g = (int)((float)g1 + (float)(g2 - g1) * lerpSpeed);
                int b = (int)((float)b1 + (float)(b2 - b1) * lerpSpeed);
                this.currentColor = r << 16 | g << 8 | b;
            } else {
                this.targetColor = 9487484;
                this.currentColor = 9487484;
            }
            this.colorTicker = 0;
        }
    }

    static {
        SITTING = class_2945.method_12791(ChameleonEntity.class, (class_2941)class_2943.field_13323);
        ATTACKING = class_2945.method_12791(ChameleonEntity.class, (class_2941)class_2943.field_13323);
        BREEDING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{ModItems.BUTTERFLY_IN_A_BOTTLE});
    }
}

