/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.List;
import java.util.function.Predicate;
import net.emilsg.clutterbestiary.entity.custom.goal.JellyfishAvoidSurfaceGoal;
import net.emilsg.clutterbestiary.entity.variants.JellyfishVariant;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class JellyfishEntity
extends class_1480 {
    private static final class_2940<String> VARIANT = class_2945.method_12791(JellyfishEntity.class, (class_2941)class_2943.field_13326);
    private static final Predicate<class_1309> TARGET_FILTER = entity -> {
        if (entity instanceof class_1657 && ((class_1657)entity).method_7337()) {
            return false;
        }
        return entity.method_5864() == class_1299.field_28315 || entity.method_6046() != class_1310.field_6292;
    };
    private static final class_4051 TARGET_PREDICATE = class_4051.method_36626().method_18424().method_36627().method_18420(TARGET_FILTER);
    public final class_7094 swimmingAnimationState = new class_7094();
    public float tiltAngle;
    public float prevTiltAngle;
    public float rollAngle;
    public float prevRollAngle;
    public float thrustTimer;
    public float prevThrustTimer;
    private float swimVelocityScale;
    private float thrustTimerSpeed;
    private float turningSpeed;
    private float swimX;
    private float swimY;
    private float swimZ;
    private int animationTimeout = 0;

    public JellyfishEntity(class_1299<? extends class_1480> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5974.method_43052((long)this.method_5628());
        this.thrustTimerSpeed = 0.25f / (this.field_5974.method_43057() + 1.0f) * 0.2f;
    }

    public static class_5132.class_5133 setAttributes() {
        return class_1480.method_26828().method_26868(class_5134.field_23716, 4.0);
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1480> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos).method_26227().method_39360((class_3611)class_3612.field_15910);
    }

    public boolean method_5931(class_1657 player) {
        return !this.method_5934();
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1309 attacker;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1309 && (attacker = (class_1309)class_12972).method_37908() instanceof class_3218 && attacker.method_6046() != class_1310.field_6292 && this.field_5974.method_43048(3) == 0) {
            attacker.method_37222(new class_1293(class_1294.field_5899, 100, 1), (class_1297)this);
        }
        return super.method_5643(source, amount);
    }

    public String getTypeVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public JellyfishVariant getVariant() {
        return JellyfishVariant.fromId(this.getTypeVariant());
    }

    public void setVariant(JellyfishVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.getId());
    }

    public boolean hasSwimmingVector() {
        return this.swimX != 0.0f || this.swimY != 0.0f || this.swimZ != 0.0f;
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        this.setVariant(JellyfishVariant.getRandom());
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.field_6011.method_12778(VARIANT, (Object)nbt.method_10558("Variant"));
    }

    public void setSwimmingVector(float x, float y, float z) {
        this.swimX = x;
        this.swimY = y;
        this.swimZ = z;
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    public float getSwimX() {
        return this.swimX;
    }

    public void setSwimX(float swimX) {
        this.swimX = swimX;
    }

    public void method_6091(class_243 movementInput) {
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("Variant", this.getTypeVariant());
    }

    protected float method_6107() {
        return 0.4f;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(VARIANT, (Object)JellyfishVariant.GREEN.getId());
    }

    public float getSwimY() {
        return this.swimY;
    }

    public void setSwimY(float swimY) {
        this.swimY = swimY;
    }

    private void sting(class_1309 mob) {
        if (mob.method_5643(this.method_48923().method_48812((class_1309)this), 2.0f)) {
            mob.method_37222(new class_1293(class_1294.field_5899, 120, 1), (class_1297)this);
            this.method_5783(class_3417.field_14863, 1.0f, 1.0f);
        }
    }

    public float getSwimZ() {
        return this.swimZ;
    }

    public void setSwimZ(float swimZ) {
        this.swimZ = swimZ;
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5805()) {
            List list = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(0.3), entity -> TARGET_PREDICATE.method_18419((class_1309)this, entity));
            for (class_1309 mobEntity : list) {
                if (!mobEntity.method_5805()) continue;
                this.sting(mobEntity);
            }
        }
        this.prevTiltAngle = this.tiltAngle;
        this.prevRollAngle = this.rollAngle;
        this.prevThrustTimer = this.thrustTimer;
        this.thrustTimer += this.thrustTimerSpeed;
        if ((double)this.thrustTimer > Math.PI * 2) {
            if (this.method_37908().field_9236) {
                this.thrustTimer = (float)Math.PI * 2;
            } else {
                this.thrustTimer -= (float)Math.PI * 2;
                if (this.field_5974.method_43048(10) == 0) {
                    this.thrustTimerSpeed = 0.25f / (this.field_5974.method_43057() + 1.0f) * 0.1f;
                }
            }
        }
        if (this.method_5816()) {
            if (this.thrustTimer < (float)Math.PI) {
                float f = this.thrustTimer / (float)Math.PI;
                if ((double)f > 0.75) {
                    this.swimVelocityScale = 1.0f;
                    this.turningSpeed = 1.0f;
                } else {
                    this.turningSpeed *= 0.8f;
                }
            } else {
                this.swimVelocityScale *= 0.9f;
                this.turningSpeed *= 0.99f;
            }
            if (!this.method_37908().field_9236) {
                this.method_18800(this.swimX * this.swimVelocityScale * 0.3f, this.swimY * this.swimVelocityScale * 0.3f, this.swimZ * this.swimVelocityScale * 0.3f);
            }
            class_243 vec3d = this.method_18798();
            double d = vec3d.method_37267();
            float targetYaw = (float)(-class_3532.method_15349((double)vec3d.field_1352, (double)vec3d.field_1350) * 57.2957763671875);
            float deltaYaw = class_3532.method_15393((float)(targetYaw - this.method_36454()));
            this.method_36456(this.method_36454() + deltaYaw * 0.1f);
            float targetPitch = (float)(-Math.toDegrees(class_3532.method_15349((double)vec3d.field_1351, (double)vec3d.method_37267())));
            float deltaPitch = class_3532.method_15393((float)(targetPitch - this.method_36455()));
            this.method_36457(this.method_36455() + deltaPitch * 0.1f);
            this.rollAngle += (float)Math.PI * this.turningSpeed * 1.5f;
            this.tiltAngle += (-((float)class_3532.method_15349((double)d, (double)vec3d.field_1351)) * 57.295776f - this.tiltAngle) * 0.05f;
            if (Math.abs(this.tiltAngle) > 30.0f) {
                this.tiltAngle *= 0.9f;
            }
        } else {
            if (!this.method_37908().field_9236) {
                double e = this.method_18798().field_1351;
                if (this.method_6059(class_1294.field_5902)) {
                    e = 0.05 * (double)(this.method_6112(class_1294.field_5902).method_5578() + 1);
                } else if (!this.method_5740()) {
                    e -= 0.08;
                }
                this.method_18800(0.0, e * (double)0.49f, 0.0);
            }
            this.tiltAngle += (-90.0f - this.tiltAngle) * 0.02f;
        }
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_15014;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SwimGoal(this));
        this.field_6201.method_6277(1, (class_1352)new JellyfishAvoidSurfaceGoal(this));
    }

    protected void method_48565(float v) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(v * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f * 1.25f, 0.5f);
    }

    private void setupAnimationStates() {
        if (this.animationTimeout <= 0) {
            this.animationTimeout = 80;
            this.swimmingAnimationState.method_41322(this.field_6012);
        } else {
            --this.animationTimeout;
        }
    }

    static class SwimGoal
    extends class_1352 {
        private final JellyfishEntity jellyfish;

        public SwimGoal(JellyfishEntity jellyfish) {
            this.jellyfish = jellyfish;
        }

        public boolean method_6264() {
            return this.jellyfish.method_5816();
        }

        public void method_6268() {
            int i = this.jellyfish.method_6131();
            if (i > 100) {
                this.jellyfish.setSwimmingVector(0.0f, 0.0f, 0.0f);
            } else if (this.jellyfish.method_6051().method_43048(SwimGoal.method_38848((int)50)) == 0 || !this.jellyfish.method_5799() || !this.jellyfish.hasSwimmingVector()) {
                float f = this.jellyfish.method_6051().method_43057() * ((float)Math.PI * 2);
                float g = class_3532.method_15362((float)f) * 0.2f;
                float h = -0.1f + this.jellyfish.method_6051().method_43057() * 0.2f;
                float j = class_3532.method_15374((float)f) * 0.2f;
                this.jellyfish.setSwimmingVector(g, h, j);
            }
        }
    }
}

