/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom;

import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.KoiEggsEntity;
import net.emilsg.clutterbestiary.entity.custom.goal.KoiMateGoal;
import net.emilsg.clutterbestiary.entity.custom.parent.ParentFishEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiVariantCompatibility;
import net.emilsg.clutterbestiary.item.ModItems;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1422;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5328;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7094;
import org.jetbrains.annotations.Nullable;

public class KoiEntity
extends ParentFishEntity {
    private static final class_2940<String> BASE_COLOR = class_2945.method_12791(KoiEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> PRIMARY_PATTERN_COLOR = class_2945.method_12791(KoiEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> PRIMARY_PATTERN_TYPE = class_2945.method_12791(KoiEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> SECONDARY_PATTERN_COLOR = class_2945.method_12791(KoiEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<String> SECONDARY_PATTERN_TYPE = class_2945.method_12791(KoiEntity.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> CHILD = class_2945.method_12791(KoiEntity.class, (class_2941)class_2943.field_13323);
    protected int breedingAge;
    protected int forcedAge;
    protected int happyTicksRemaining;
    private int loveTicks;
    private final class_1792 breedingItem = class_1802.field_17532;
    @Nullable
    private UUID lovingPlayer;
    public final class_7094 swimmingAnimationState = new class_7094();
    private int swimmingAnimationTimeout = 0;

    public KoiEntity(class_1299<? extends class_1422> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BASE_COLOR, (Object)KoiBaseColorVariant.ORANGE.getID());
        this.field_6011.method_12784(PRIMARY_PATTERN_COLOR, (Object)KoiPrimaryPatternColorVariant.WHITE.getID());
        this.field_6011.method_12784(PRIMARY_PATTERN_TYPE, (Object)KoiPrimaryPatternTypeVariant.SPOTTED.getID());
        this.field_6011.method_12784(SECONDARY_PATTERN_COLOR, (Object)KoiSecondaryPatternColorVariant.BLACK.getID());
        this.field_6011.method_12784(SECONDARY_PATTERN_TYPE, (Object)KoiSecondaryPatternTypeVariant.SMALL_SPOTS.getID());
        this.field_6011.method_12784(CHILD, (Object)false);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(1, (class_1352)new KoiMateGoal(this, 1.0, KoiEntity.class));
        this.field_6201.method_6277(2, (class_1352)new class_1391((class_1314)this, 1.25, class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_17532}), false));
    }

    public void method_5773() {
        super.method_5773();
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            this.setupAnimationStates();
        }
    }

    private void setupAnimationStates() {
        if (this.swimmingAnimationTimeout <= 0) {
            this.swimmingAnimationTimeout = 20;
            this.swimmingAnimationState.method_41322(this.field_6012);
        } else {
            --this.swimmingAnimationTimeout;
        }
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10582("BaseColor", this.getBaseColorVariant().getID());
        nbt.method_10582("PrimaryPatternColor", this.getPrimaryPatternColorVariant().getID());
        nbt.method_10582("PrimaryPatternType", this.getPrimaryPatternTypeVariant().getID());
        nbt.method_10582("SecondaryPatternColor", this.getSecondaryPatternColorVariant().getID());
        nbt.method_10582("SecondaryPatternType", this.getSecondaryPatternTypeVariant().getID());
        nbt.method_10569("InLove", this.loveTicks);
        if (this.lovingPlayer != null) {
            nbt.method_25927("LoveCause", this.lovingPlayer);
        }
        nbt.method_10569("Age", this.getBreedingAge());
        nbt.method_10569("ForcedAge", this.forcedAge);
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setBaseColorVariant(KoiBaseColorVariant.fromId(nbt.method_10558("BaseColor")));
        this.setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant.fromId(nbt.method_10558("PrimaryPatternColor")));
        this.setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant.fromId(nbt.method_10558("PrimaryPatternType")));
        this.setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant.fromId(nbt.method_10558("SecondaryPatternColor")));
        this.setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant.fromId(nbt.method_10558("SecondaryPatternType")));
        this.loveTicks = nbt.method_10550("InLove");
        this.lovingPlayer = nbt.method_25928("LoveCause") ? nbt.method_25926("LoveCause") : null;
        this.setBreedingAge(nbt.method_10550("Age"));
        this.forcedAge = nbt.method_10550("ForcedAge");
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData, @Nullable class_2487 entityNbt) {
        KoiSecondaryPatternTypeVariant secondaryType;
        KoiSecondaryPatternColorVariant secondaryColor;
        KoiPrimaryPatternTypeVariant primaryType;
        KoiPrimaryPatternColorVariant primaryColor;
        KoiBaseColorVariant base;
        class_1296.class_4697 passiveData;
        if (entityData == null) {
            entityData = new class_1296.class_4697(true);
        }
        if ((passiveData = (class_1296.class_4697)entityData).method_22436() && passiveData.method_22432() > 0 && world.method_8409().method_43057() <= passiveData.method_22437()) {
            this.setBreedingAge(-24000);
        }
        passiveData.method_22435();
        while (!KoiVariantCompatibility.isValid(base = KoiBaseColorVariant.getRandom(), primaryColor = KoiPrimaryPatternColorVariant.getRandom(), primaryType = KoiPrimaryPatternTypeVariant.getRandom(), secondaryColor = KoiSecondaryPatternColorVariant.getRandom(), secondaryType = KoiSecondaryPatternTypeVariant.getRandom())) {
        }
        this.setBaseColorVariant(base);
        this.setPrimaryPatternColorVariant(primaryColor);
        this.setPrimaryPatternTypeVariant(primaryType);
        this.setSecondaryPatternColorVariant(secondaryColor);
        this.setSecondaryPatternTypeVariant(secondaryType);
        if (base.hasSeparateTexture()) {
            this.setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant.NONE);
            this.setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant.NONE);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData, entityNbt);
    }

    public KoiBaseColorVariant getBaseColorVariant() {
        return KoiBaseColorVariant.fromId((String)this.field_6011.method_12789(BASE_COLOR));
    }

    @Nullable
    protected class_3414 method_6002() {
        return class_3417.field_15123;
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14638;
    }

    public void setBaseColorVariant(KoiBaseColorVariant baseColorVariant) {
        this.field_6011.method_12778(BASE_COLOR, (Object)baseColorVariant.getID());
    }

    public KoiPrimaryPatternColorVariant getPrimaryPatternColorVariant() {
        return KoiPrimaryPatternColorVariant.fromId((String)this.field_6011.method_12789(PRIMARY_PATTERN_COLOR));
    }

    public void setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant primaryPatternColorVariant) {
        this.field_6011.method_12778(PRIMARY_PATTERN_COLOR, (Object)primaryPatternColorVariant.getID());
    }

    public KoiPrimaryPatternTypeVariant getPrimaryPatternTypeVariant() {
        return KoiPrimaryPatternTypeVariant.fromId((String)this.field_6011.method_12789(PRIMARY_PATTERN_TYPE));
    }

    public void setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant primaryPatternTypeVariant) {
        this.field_6011.method_12778(PRIMARY_PATTERN_TYPE, (Object)primaryPatternTypeVariant.getID());
    }

    public KoiSecondaryPatternColorVariant getSecondaryPatternColorVariant() {
        return KoiSecondaryPatternColorVariant.fromId((String)this.field_6011.method_12789(SECONDARY_PATTERN_COLOR));
    }

    public void setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant secondaryPatternColorVariant) {
        this.field_6011.method_12778(SECONDARY_PATTERN_COLOR, (Object)secondaryPatternColorVariant.getID());
    }

    public KoiSecondaryPatternTypeVariant getSecondaryPatternTypeVariant() {
        return KoiSecondaryPatternTypeVariant.fromId((String)this.field_6011.method_12789(SECONDARY_PATTERN_TYPE));
    }

    public void setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant secondaryPatternTypeVariant) {
        this.field_6011.method_12778(SECONDARY_PATTERN_TYPE, (Object)secondaryPatternTypeVariant.getID());
    }

    public static class_5132.class_5133 setAttributes() {
        return ParentFishEntity.method_26828().method_26868(class_5134.field_23716, 6.0);
    }

    @Override
    public class_1799 method_6452() {
        return new class_1799((class_1935)ModItems.KOI_BUCKET);
    }

    @Override
    protected class_3414 method_6457() {
        return class_3417.field_14878;
    }

    public void method_6455(class_1799 stack) {
        class_2487 nbtCompound = stack.method_7948();
        if (this.method_16914()) {
            stack.method_7977(this.method_5797());
        }
        if (this.method_5987()) {
            nbtCompound.method_10556("NoAI", this.method_5987());
        }
        if (this.method_5701()) {
            nbtCompound.method_10556("Silent", this.method_5701());
        }
        if (this.method_5740()) {
            nbtCompound.method_10556("NoGravity", this.method_5740());
        }
        if (this.method_36361()) {
            nbtCompound.method_10556("Glowing", this.method_36361());
        }
        if (this.method_5655()) {
            nbtCompound.method_10556("Invulnerable", this.method_5655());
        }
        nbtCompound.method_10548("Health", this.method_6032());
        nbtCompound.method_10582("BaseColor", this.getBaseColorVariant().getID());
        nbtCompound.method_10582("PrimaryPatternColor", this.getPrimaryPatternColorVariant().getID());
        nbtCompound.method_10582("PrimaryPatternType", this.getPrimaryPatternTypeVariant().getID());
        nbtCompound.method_10582("SecondaryPatternColor", this.getSecondaryPatternColorVariant().getID());
        nbtCompound.method_10582("SecondaryPatternType", this.getSecondaryPatternTypeVariant().getID());
    }

    public void copyDataFromNbt(KoiEntity entity, class_2487 nbt) {
        if (nbt.method_10545("NoAI")) {
            entity.method_5977(nbt.method_10577("NoAI"));
        }
        if (nbt.method_10545("Silent")) {
            entity.method_5803(nbt.method_10577("Silent"));
        }
        if (nbt.method_10545("NoGravity")) {
            entity.method_5875(nbt.method_10577("NoGravity"));
        }
        if (nbt.method_10545("Glowing")) {
            entity.method_5834(nbt.method_10577("Glowing"));
        }
        if (nbt.method_10545("Invulnerable")) {
            entity.method_5684(nbt.method_10577("Invulnerable"));
        }
        if (nbt.method_10573("Health", 99)) {
            entity.method_6033(nbt.method_10583("Health"));
        }
        if (nbt.method_10573("Health", 99)) {
            entity.method_6033(nbt.method_10583("Health"));
        }
        if (nbt.method_10573("BaseColor", 8)) {
            entity.setBaseColorVariant(KoiBaseColorVariant.fromId(nbt.method_10558("BaseColor")));
        }
        if (nbt.method_10573("PrimaryPatternColor", 8)) {
            entity.setPrimaryPatternColorVariant(KoiPrimaryPatternColorVariant.fromId(nbt.method_10558("PrimaryPatternColor")));
        }
        if (nbt.method_10573("PrimaryPatternType", 8)) {
            entity.setPrimaryPatternTypeVariant(KoiPrimaryPatternTypeVariant.fromId(nbt.method_10558("PrimaryPatternType")));
        }
        if (nbt.method_10573("SecondaryPatternColor", 8)) {
            entity.setSecondaryPatternColorVariant(KoiSecondaryPatternColorVariant.fromId(nbt.method_10558("SecondaryPatternColor")));
        }
        if (nbt.method_10573("SecondaryPatternType", 8)) {
            entity.setSecondaryPatternTypeVariant(KoiSecondaryPatternTypeVariant.fromId(nbt.method_10558("SecondaryPatternType")));
        }
    }

    private class_1269 tryBucket(class_1657 player, class_1268 hand, KoiEntity koiEntity) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_7909() == class_1802.field_8705 && koiEntity.method_5805()) {
            koiEntity.method_5783(koiEntity.method_35171(), 1.0f, 1.0f);
            class_1799 filledBucketItem = koiEntity.method_6452();
            koiEntity.method_6455(filledBucketItem);
            class_1799 itemStack3 = class_5328.method_30270((class_1799)itemStack, (class_1657)player, (class_1799)filledBucketItem, (boolean)false);
            player.method_6122(hand, itemStack3);
            class_1937 world = koiEntity.method_37908();
            if (!world.field_9236) {
                class_174.field_1208.method_8932((class_3222)player, filledBucketItem);
            }
            koiEntity.method_31472();
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (this.isBreedingItem(itemStack)) {
            int i = this.getBreedingAge();
            if (!this.method_37908().field_9236 && i == 0 && this.canEat()) {
                this.eat(player, hand, itemStack);
                this.lovePlayer(player);
                return class_1269.field_5812;
            }
            if (this.method_6109()) {
                this.eat(player, hand, itemStack);
                this.growUp(KoiEntity.toGrowUpAge(-i), true);
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (this.method_37908().field_9236) {
                return class_1269.field_21466;
            }
        } else if (itemStack.method_31574(class_1802.field_8550)) {
            return this.tryBucket(player, hand, this);
        }
        return super.method_5992(player, hand);
    }

    public static boolean isValidNaturalSpawn(class_1299<? extends class_1480> type, class_1936 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return world.method_8320(pos).method_26227().method_39360((class_3611)class_3612.field_15910);
    }

    public static int toGrowUpAge(int breedingAge) {
        return (int)((float)(breedingAge / 20) * 0.1f);
    }

    public void breed(class_3218 world, KoiEntity other) {
        this.breed(world, other, null);
    }

    public void breed(class_3218 world, KoiEntity other, @Nullable KoiEntity baby) {
        KoiSecondaryPatternTypeVariant secondaryType;
        KoiSecondaryPatternColorVariant secondaryColor;
        KoiPrimaryPatternTypeVariant primaryType;
        KoiPrimaryPatternColorVariant primaryColor;
        KoiBaseColorVariant base;
        this.setBreedingAge(6000);
        other.setBreedingAge(6000);
        KoiEggsEntity koiEggs = (KoiEggsEntity)ModEntityTypes.KOI_EGGS.method_5883((class_1937)world);
        if (koiEggs == null) {
            return;
        }
        while (!KoiVariantCompatibility.isValid(base = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getBaseColorVariant, KoiBaseColorVariant::getRandom), primaryColor = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getPrimaryPatternColorVariant, KoiPrimaryPatternColorVariant::getRandom), primaryType = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getPrimaryPatternTypeVariant, KoiPrimaryPatternTypeVariant::getRandom), secondaryColor = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getSecondaryPatternColorVariant, KoiSecondaryPatternColorVariant::getRandom), secondaryType = this.getWeightedVariant(this, other, 40, 40, 20, KoiEntity::getSecondaryPatternTypeVariant, KoiSecondaryPatternTypeVariant::getRandom))) {
        }
        koiEggs.setBaseColorVariant(base);
        koiEggs.setPrimaryPatternColorVariant(primaryColor);
        koiEggs.setPrimaryPatternTypeVariant(primaryType);
        koiEggs.setSecondaryPatternColorVariant(secondaryColor);
        koiEggs.setSecondaryPatternTypeVariant(secondaryType);
        koiEggs.method_5808(this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
        world.method_8649((class_1297)koiEggs);
        this.resetLoveTicks();
        other.resetLoveTicks();
        world.method_8421((class_1297)this, (byte)18);
        if (world.method_8450().method_8355(class_1928.field_19391)) {
            int xp = this.method_6051().method_43048(7) + 1;
            world.method_8649((class_1297)new class_1303((class_1937)world, this.method_23317(), this.method_23318(), this.method_23321(), xp));
        }
    }

    public <T> T getWeightedVariant(KoiEntity parent1, KoiEntity parent2, int parent1Weight, int parent2Weight, int randomWeight, Function<KoiEntity, T> getter, Supplier<T> randomSupplier) {
        int total = parent1Weight + parent2Weight + randomWeight;
        int decider = parent1.method_6051().method_43048(total);
        if (decider < parent1Weight) {
            return getter.apply(parent1);
        }
        if (decider < parent1Weight + parent2Weight) {
            return getter.apply(parent2);
        }
        return randomSupplier.get();
    }

    public boolean canBreedWith(KoiEntity other) {
        if (other == this) {
            return false;
        }
        if (((Object)((Object)other)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.isInLove() && other.isInLove();
    }

    public boolean canEat() {
        return this.loveTicks <= 0;
    }

    @Nullable
    public KoiEntity createChild(class_3218 world, KoiEntity entity) {
        return (KoiEntity)ModEntityTypes.KOI.method_5883((class_1937)world);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.loveTicks = 0;
        return super.method_5643(source, amount);
    }

    public int getBreedingAge() {
        if (this.method_37908().field_9236) {
            return (Boolean)this.field_6011.method_12789(CHILD) != false ? -1 : 1;
        }
        return this.breedingAge;
    }

    public void setBreedingAge(int age) {
        int i = this.getBreedingAge();
        this.breedingAge = age;
        if (i < 0 && age >= 0 || i >= 0 && age < 0) {
            this.field_6011.method_12778(CHILD, (Object)(age < 0 ? 1 : 0));
            this.onGrowUp();
        }
    }

    public int getLoveTicks() {
        return this.loveTicks;
    }

    public void setLoveTicks(int loveTicks) {
        this.loveTicks = loveTicks;
    }

    @Nullable
    public class_3222 getLovingPlayer() {
        if (this.lovingPlayer == null) {
            return null;
        }
        class_1657 playerEntity = this.method_37908().method_18470(this.lovingPlayer);
        return playerEntity instanceof class_3222 ? (class_3222)playerEntity : null;
    }

    public void growUp(int age, boolean overGrow) {
        int i;
        int j = i = this.getBreedingAge();
        if ((i += age * 20) > 0) {
            i = 0;
        }
        int k = i - j;
        this.setBreedingAge(i);
        if (overGrow) {
            this.forcedAge += k;
            if (this.happyTicksRemaining == 0) {
                this.happyTicksRemaining = 40;
            }
        }
        if (this.getBreedingAge() == 0) {
            this.setBreedingAge(this.forcedAge);
        }
    }

    public void growUp(int age) {
        this.growUp(age, false);
    }

    public void method_5711(byte status) {
        if (status == 18) {
            for (int i = 0; i < 7; ++i) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        } else {
            super.method_5711(status);
        }
    }

    public boolean method_6109() {
        return this.getBreedingAge() < 0;
    }

    public void method_7217(boolean baby) {
        this.setBreedingAge(baby ? -24000 : 0);
    }

    public boolean isBreedingItem(class_1799 stack) {
        return stack.method_31574(this.breedingItem);
    }

    public boolean isInLove() {
        return this.getLoveTicks() > 0;
    }

    public boolean isReadyToBreed() {
        return false;
    }

    public void lovePlayer(@Nullable class_1657 player) {
        this.loveTicks = 600;
        if (player != null) {
            this.lovingPlayer = player.method_5667();
        }
        this.method_37908().method_8421((class_1297)this, (byte)18);
    }

    public void method_5674(class_2940<?> data) {
        if (CHILD.equals(data)) {
            this.method_18382();
        }
        super.method_5674(data);
    }

    public void resetLoveTicks() {
        this.setLoveTicks(0);
    }

    @Override
    public void method_6007() {
        if (!this.method_5799() && this.method_24828() && this.field_5992) {
            this.method_18799(this.method_18798().method_1031((double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.05f), (double)0.4f, (double)((this.field_5974.method_43057() * 2.0f - 1.0f) * 0.05f)));
            this.method_24830(false);
            this.field_6007 = true;
            this.method_5783(this.method_6457(), this.method_6107(), this.method_6017());
        }
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.loveTicks % 10 == 0) {
                double d = this.field_5974.method_43059() * 0.02;
                double e = this.field_5974.method_43059() * 0.02;
                double f = this.field_5974.method_43059() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11201, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
            }
        }
        if (this.method_37908().field_9236) {
            if (this.happyTicksRemaining > 0) {
                if (this.happyTicksRemaining % 4 == 0) {
                    this.method_37908().method_8406((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), 0.0, 0.0, 0.0);
                }
                --this.happyTicksRemaining;
            }
        } else if (this.method_5805()) {
            int i = this.getBreedingAge();
            if (i < 0) {
                this.setBreedingAge(++i);
            } else if (i > 0) {
                this.setBreedingAge(--i);
            }
        }
        super.method_6007();
    }

    protected void eat(class_1657 player, class_1268 hand, class_1799 stack) {
        if (!player.method_31549().field_7477) {
            stack.method_7934(1);
        }
    }

    protected void method_5958() {
        if (this.getBreedingAge() != 0) {
            this.loveTicks = 0;
        }
        super.method_5958();
    }

    protected void onGrowUp() {
        class_1690 boatEntity;
        class_1297 var2;
        if (!this.method_6109() && this.method_5765() && (var2 = this.method_5854()) instanceof class_1690 && !(boatEntity = (class_1690)var2).method_49182((class_1297)this)) {
            this.method_5848();
        }
    }
}

