/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_2960;

public enum ButterflyVariant {
    WHITE("white", class_124.field_1068),
    LIGHT_GRAY("light_gray", class_124.field_1080),
    GRAY("gray", class_124.field_1063),
    BLACK("black", class_124.field_1074),
    BROWN("brown", class_124.field_1065),
    RED("red", class_124.field_1079),
    ORANGE("orange", class_124.field_1065),
    YELLOW("yellow", class_124.field_1054),
    LIME("lime", class_124.field_1060),
    GREEN("green", class_124.field_1077),
    LIGHT_BLUE("light_blue", class_124.field_1078),
    CYAN("cyan", class_124.field_1062),
    BLUE("blue", class_124.field_1058),
    PURPLE("purple", class_124.field_1064),
    MAGENTA("magenta", class_124.field_1076),
    PINK("pink", class_124.field_1061),
    WARPED("warped", class_124.field_1062, true),
    CRIMSON("crimson", class_124.field_1079, true),
    SOUL("soul", class_124.field_1065, true);

    private final String name;
    private final class_124 colorFormatting;
    private final boolean isFireImmune;

    private ButterflyVariant(String name, class_124 colorFormatting, boolean isFireImmune) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.isFireImmune = isFireImmune;
    }

    private ButterflyVariant(String name, class_124 colorFormatting) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.isFireImmune = false;
    }

    public static ButterflyVariant fromId(String id) {
        return Arrays.stream(ButterflyVariant.values()).filter(v -> v.getId().equals(id)).findFirst().orElse(WHITE);
    }

    public static ButterflyVariant getRandom(boolean overworldOnly) {
        List<ButterflyVariant> filtered = Arrays.stream(ButterflyVariant.values()).filter(v -> !overworldOnly || !v.isFireImmune()).toList();
        return filtered.get(new Random().nextInt(filtered.size()));
    }

    public class_124 getColorFormatting() {
        return this.colorFormatting;
    }

    public String getId() {
        return "clutterbestiary:" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public class_2960 getTextureLocation() {
        return class_2960.method_43902((String)"clutterbestiary", (String)("textures/entity/butterfly/" + this.getName() + "_butterfly.png"));
    }

    public boolean isFireImmune() {
        return this.isFireImmune;
    }
}

