/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.item.custom;

import java.util.List;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.KoiEntity;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiPrimaryPatternTypeVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternColorVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiSecondaryPatternTypeVariant;
import net.emilsg.clutterbestiary.util.ModUtil;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

public class KoiBucketItem
extends class_1785 {
    private final class_1299<KoiEntity> entityType;

    public KoiBucketItem(class_1299<KoiEntity> type, class_3611 fluid, class_3414 emptyingSound, class_1792.class_1793 settings) {
        super(type, fluid, emptyingSound, settings);
        this.entityType = type;
    }

    public void method_7728(@Nullable class_1657 player, class_1937 world, class_1799 stack, class_2338 pos) {
        if (world instanceof class_3218) {
            this.spawnEntity((class_3218)world, stack, pos);
            world.method_33596((class_1297)player, class_5712.field_28738, pos);
        }
    }

    private void spawnEntity(class_3218 world, class_1799 stack, class_2338 pos) {
        KoiEntity koi = (KoiEntity)ModEntityTypes.KOI.method_5883((class_1937)world);
        if (koi == null) {
            return;
        }
        koi.copyDataFromNbt(koi, stack.method_7948());
        koi.method_5725(pos, 0.0f, 0.0f);
        koi.method_6454(true);
        if (stack.method_7938()) {
            koi.method_5665(stack.method_7964());
        }
        world.method_8649((class_1297)koi);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        class_2487 nbt = stack.method_7969();
        if (this.entityType != ModEntityTypes.KOI || nbt == null) {
            return;
        }
        if (!nbt.method_10573("BaseColor", 8)) {
            return;
        }
        if (!nbt.method_10573("PrimaryPatternType", 8)) {
            return;
        }
        if (!nbt.method_10573("SecondaryPatternType", 8)) {
            return;
        }
        KoiBaseColorVariant base = KoiBaseColorVariant.fromId(nbt.method_10558("BaseColor"));
        tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.clutterbestiary.base_color.koi").method_27692(class_124.field_1080));
        if (base.hasSeparateTexture()) {
            int tick = (int)(System.currentTimeMillis() / 100L) % base.getColorHex().length;
            tooltip.add(ModUtil.buildCyclicFormattedName("tooltip.clutterbestiary." + base.getName() + ".koi", base.getColorHex(), tick, true));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)("tooltip.clutterbestiary." + base.getName() + ".koi")).method_27692(base.getFormatting()));
        }
        if (!base.hasSeparateTexture()) {
            KoiPrimaryPatternTypeVariant primaryPatternType = KoiPrimaryPatternTypeVariant.fromId(nbt.method_10558("PrimaryPatternType"));
            KoiPrimaryPatternColorVariant primaryPatternColor = KoiPrimaryPatternColorVariant.fromId(nbt.method_10558("PrimaryPatternColor"));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.clutterbestiary.primary_pattern.koi").method_27692(class_124.field_1080));
            class_5250 primaryText = class_2561.method_43471((String)("tooltip.clutterbestiary." + primaryPatternType.getName() + ".koi")).method_27692(primaryPatternType.getFormatting()).method_27692(primaryPatternColor.getFormatting());
            tooltip.add((class_2561)primaryText);
            KoiSecondaryPatternTypeVariant secondaryPatternType = KoiSecondaryPatternTypeVariant.fromId(nbt.method_10558("SecondaryPatternType"));
            KoiSecondaryPatternColorVariant secondaryPatternColor = KoiSecondaryPatternColorVariant.fromId(nbt.method_10558("SecondaryPatternColor"));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.clutterbestiary.secondary_pattern.koi").method_27692(class_124.field_1080));
            class_5250 secondaryText = class_2561.method_43471((String)("tooltip.clutterbestiary." + secondaryPatternType.getName() + ".koi")).method_27692(secondaryPatternType.getFormatting()).method_27692(secondaryPatternColor.getFormatting());
            tooltip.add((class_2561)secondaryText);
        }
        tooltip.add(class_5244.field_39003);
    }
}

