/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.util;

import net.emilsg.clutterbestiary.entity.variants.SeahorseVariant;
import net.emilsg.clutterbestiary.entity.variants.koi.KoiBaseColorVariant;
import net.emilsg.clutterbestiary.item.custom.BestiaryElytraItem;
import net.emilsg.clutterbestiary.item.custom.ButterflyBottleItem;
import net.emilsg.clutterbestiary.item.custom.KoiBucketItem;
import net.emilsg.clutterbestiary.item.custom.SeahorseBucketItem;
import net.minecraft.class_1792;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5272;
import net.minecraft.class_7923;

public class ModModelPredicateProvider {
    public static void register() {
        for (class_1792 item : class_7923.field_41178) {
            if (item instanceof BestiaryElytraItem) {
                ModModelPredicateProvider.registerElytra(item);
            }
            if (item instanceof ButterflyBottleItem) {
                ModModelPredicateProvider.registerButterflyInABottle(item);
            }
            if (item instanceof SeahorseBucketItem) {
                ModModelPredicateProvider.registerSeahorseBucket(item);
            }
            if (!(item instanceof KoiBucketItem)) continue;
            ModModelPredicateProvider.registerKoiBucket(item);
        }
    }

    private static void registerElytra(class_1792 elytra) {
        class_5272.method_27879((class_1792)elytra, (class_2960)class_2960.method_43902((String)"minecraft", (String)"broken"), (stack, world, entity, seed) -> {
            class_1792 patt0$temp = stack.method_7909();
            if (!(patt0$temp instanceof BestiaryElytraItem)) {
                return 0.0f;
            }
            BestiaryElytraItem bestiaryElytraItem = (BestiaryElytraItem)patt0$temp;
            return bestiaryElytraItem.isBroken(stack) ? 1.0f : 0.0f;
        });
    }

    private static void registerButterflyInABottle(class_1792 bottle) {
        class_5272.method_27879((class_1792)bottle, (class_2960)class_2960.method_43902((String)"minecraft", (String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof ButterflyBottleItem)) {
                return 0.0f;
            }
            class_2487 nbtCompound = stack.method_7969();
            if (nbtCompound == null || !nbtCompound.method_10545("Variant")) {
                return 0.0f;
            }
            int id = nbtCompound.method_10550("Variant");
            return (float)id / 100.0f;
        });
    }

    private static void registerSeahorseBucket(class_1792 bucket) {
        class_5272.method_27879((class_1792)bucket, (class_2960)class_2960.method_43902((String)"minecraft", (String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof SeahorseBucketItem)) {
                return 0.0f;
            }
            class_2487 nbtCompound = stack.method_7969();
            if (nbtCompound == null || !nbtCompound.method_10545("Variant")) {
                return 0.0f;
            }
            SeahorseVariant seahorseVariant = SeahorseVariant.fromId(nbtCompound.method_10558("Variant"));
            float type = switch (seahorseVariant) {
                case SeahorseVariant.LIGHT_BLUE -> 0.1f;
                case SeahorseVariant.RED -> 0.2f;
                case SeahorseVariant.PURPLE -> 0.3f;
                default -> 0.0f;
            };
            return type;
        });
    }

    private static void registerKoiBucket(class_1792 bucket) {
        class_5272.method_27879((class_1792)bucket, (class_2960)class_2960.method_43902((String)"minecraft", (String)"type"), (stack, world, entity, seed) -> {
            if (!(stack.method_7909() instanceof KoiBucketItem)) {
                return 0.0f;
            }
            class_2487 nbtCompound = stack.method_7969();
            if (nbtCompound == null || !nbtCompound.method_10545("BaseColor")) {
                return 0.0f;
            }
            KoiBaseColorVariant id = KoiBaseColorVariant.fromId(nbtCompound.method_10558("BaseColor"));
            float type = switch (id) {
                case KoiBaseColorVariant.ORANGE -> 0.1f;
                case KoiBaseColorVariant.YELLOW -> 0.2f;
                case KoiBaseColorVariant.BLACK -> 0.3f;
                case KoiBaseColorVariant.PEARL -> 0.4f;
                default -> 0.0f;
            };
            return type;
        });
    }
}

