/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.client.entity;

import com.modderg.tameablebeasts.server.entity.abstracts.FlyingRideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.abstracts.FlyingTBAnimal;
import com.modderg.tameablebeasts.server.entity.abstracts.RideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public final class TBAnimControllers {
    public static void setLoopAnimation(AnimationState<?> event, String animationName) {
        event.getController().setAnimation(RawAnimation.begin().then(animationName, Animation.LoopType.LOOP));
    }

    public static <T extends TBAnimal> PlayState groundState(T entity, AnimationState<?> event) {
        if (event.isMoving() || entity.m_6147_()) {
            TBAnimControllers.setLoopAnimation(event, entity.isRunning() ? "run" : "walk");
        } else if (entity.m_21825_()) {
            TBAnimControllers.setLoopAnimation(event, "sit");
        } else {
            TBAnimControllers.setLoopAnimation(event, "idle");
        }
        return PlayState.CONTINUE;
    }

    public static <T extends FlyingTBAnimal> PlayState flyState(T entity, AnimationState<T> event) {
        if (entity.isStill()) {
            TBAnimControllers.setLoopAnimation(event, "fly_idle");
        } else {
            TBAnimControllers.setLoopAnimation(event, "fly");
        }
        return PlayState.CONTINUE;
    }

    public static <T extends RideableTBAnimal> PlayState vehicleState(T entity, AnimationState<T> event) {
        if (entity.m_20160_()) {
            if (entity.moving) {
                event.getController().setAnimation(RawAnimation.begin().then("run", Animation.LoopType.LOOP));
            } else {
                event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
            }
            return PlayState.CONTINUE;
        }
        return TBAnimControllers.groundState(entity, event);
    }

    public static <T extends RideableTBAnimal> AnimationController<T> vehicleController(T entity) {
        return new AnimationController(entity, "movement", 2, event -> TBAnimControllers.vehicleState(entity, event));
    }

    public static <T extends TBAnimal> AnimationController<T> groundController(T entity) {
        return new AnimationController(entity, "movement", 5, event -> TBAnimControllers.groundState(entity, event));
    }

    public static <T extends FlyingRideableTBAnimal> AnimationController<T> flyGliderController(T entity) {
        return new AnimationController(entity, "movement", 5, event -> {
            if (entity.isClientFlying() && !entity.m_21825_()) {
                if (entity.m_6109_()) {
                    if (entity.downInput) {
                        TBAnimControllers.setLoopAnimation(event, "glide_down");
                    } else if (entity.upInput) {
                        TBAnimControllers.setLoopAnimation(event, "fly");
                    } else if (entity.isStill()) {
                        TBAnimControllers.setLoopAnimation(event, "fly_idle");
                    } else {
                        TBAnimControllers.setLoopAnimation(event, "glide");
                    }
                } else if (entity.isStill()) {
                    TBAnimControllers.setLoopAnimation(event, "fly_idle");
                } else {
                    double d = entity.m_20184_().f_82480_;
                    double d2 = entity.m_6109_() ? 0.0 : -0.2;
                    if (d < d2) {
                        TBAnimControllers.setLoopAnimation(event, "glide");
                    } else {
                        TBAnimControllers.setLoopAnimation(event, "fly");
                    }
                }
                return PlayState.CONTINUE;
            }
            return TBAnimControllers.groundState(entity, event);
        });
    }

    public static <T extends FlyingTBAnimal> AnimationController<T> flyWalkingController(T entity) {
        return new AnimationController(entity, "movement", 5, event -> {
            if (entity.isClientFlying()) {
                return TBAnimControllers.flyState(entity, event);
            }
            return TBAnimControllers.groundState(entity, event);
        });
    }

    public static <T extends FlyingTBAnimal> AnimationController<T> flyOnlyController(T entity) {
        return new AnimationController(entity, "movement", 10, event -> {
            if (!entity.m_21825_() || !entity.isStill()) {
                return TBAnimControllers.flyState(entity, event);
            }
            TBAnimControllers.setLoopAnimation(event, "sit");
            return PlayState.CONTINUE;
        });
    }
}

