/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.client.gui;

import com.modderg.tameablebeasts.client.gui.SpecialSlot;
import com.modderg.tameablebeasts.client.gui.ToggeableSlot;
import com.modderg.tameablebeasts.registry.TBAdvancementRegistry;
import com.modderg.tameablebeasts.registry.TBMenuRegistry;
import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import oshi.util.tuples.Pair;

public class TBMenu
extends AbstractContainerMenu {
    protected final TBAnimal tbAnimal;
    protected int chestSlot = -1;
    boolean hadChest = false;
    protected List<Pair<Pair<Integer, Integer>, ResourceLocation>> advancementsInfo = new ArrayList<Pair<Pair<Integer, Integer>, ResourceLocation>>();
    public List<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>> specialSlots = new ArrayList<Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>>();
    protected static final Pair<Integer, Integer> FIRST_SLOT_POS = new Pair((Object)7, (Object)17);
    protected static final Pair<Integer, Integer> SECOND_SLOT_POS = new Pair((Object)7, (Object)35);
    protected static final Pair<Integer, Integer> THIRD_SLOT_POS = new Pair((Object)7, (Object)53);
    protected static final Pair<Integer, Integer> FOURTH_SLOT_POS = new Pair((Object)79, (Object)17);
    protected static final Pair<Integer, Integer> FIFTH_SLOT_POS = new Pair((Object)79, (Object)35);
    protected static final Pair<Integer, Integer> SIXTH_SLOT_POS = new Pair((Object)79, (Object)53);
    protected static final Pair<Integer, Integer> CHEST_SLOT_TEXTURE = new Pair((Object)0, (Object)220);
    protected static final Pair<Integer, Integer> SADDLE_SLOT_TEXTURE = new Pair((Object)18, (Object)220);
    protected static final Pair<Integer, Integer> STAND_SLOT_TEXTURE = new Pair((Object)36, (Object)220);
    protected static final Pair<Integer, Integer> ICE_HELMET_SLOT_TEXTURE = new Pair((Object)54, (Object)220);
    protected static final Pair<Integer, Integer> ICE_CHESTPLATE_SLOT_TEXTURE = new Pair((Object)72, (Object)220);
    protected static final Pair<Integer, Integer> POPSICLE_SLOT_TEXTURE = new Pair((Object)90, (Object)220);
    protected static final Pair<Integer, Integer> SCYTHE_SLOT_TEXTURE = new Pair((Object)108, (Object)220);

    public TBMenu(MenuType<?> menuType, int container_id, Inventory playerInventory, Entity tbAnimal) {
        super(menuType, container_id);
        this.tbAnimal = (TBAnimal)tbAnimal;
        this.setupSlots();
        this.createPlayerHotBar(playerInventory);
        this.createPlayerInventory(playerInventory);
        this.checkAdvancementsAndChests();
    }

    public TBMenu(int container_id, Inventory playerInventory, FriendlyByteBuf extraData) {
        this((MenuType)TBMenuRegistry.TBMOB_MENU_CONTAINER.get(), container_id, playerInventory, Objects.requireNonNull(playerInventory.f_35978_.m_9236_().m_6815_(extraData.readInt())));
    }

    public TBMenu(int container_id, Inventory playerInventory, Entity tbAnimal) {
        this((MenuType)TBMenuRegistry.TBMOB_MENU_CONTAINER.get(), container_id, playerInventory, tbAnimal);
    }

    protected void setupSlots() {
    }

    protected void setupChestSlots() {
        this.tbAnimal.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inventory -> {
            for (int row = 0; row < 3; ++row) {
                for (int column = 0; column < 5; ++column) {
                    this.m_38897_((Slot)new ToggeableSlot((IItemHandler)inventory, this.f_38839_.size(), 80 + column * 18, 18 + row * 18));
                }
            }
        });
    }

    public void checkAdvancementsAndChests() {
        this.shouldToggleSlotsCheck();
        this.shouldTriggerAdvancementCheck();
    }

    public void shouldToggleSlotsCheck() {
        if (this.chestSlot != -1) {
            if (((Slot)this.f_38839_.get(this.chestSlot)).m_7993_().m_150930_(Items.f_42009_)) {
                if (!this.hadChest) {
                    this.toggleChestSlots(true);
                }
            } else if (this.hadChest) {
                this.toggleChestSlots(false);
                this.dropChestContents();
            }
        }
    }

    public void shouldTriggerAdvancementCheck() {
        for (Pair<Pair<Integer, Integer>, ResourceLocation> advancementInfo : this.advancementsInfo) {
            LivingEntity livingEntity;
            Pair range = (Pair)advancementInfo.getA();
            ResourceLocation advancement = (ResourceLocation)advancementInfo.getB();
            boolean shouldGrant = IntStream.rangeClosed((Integer)range.getA(), (Integer)range.getB()).allMatch(i -> {
                SpecialSlot slot;
                Slot patt4971$temp = this.m_38853_(i);
                return patt4971$temp instanceof SpecialSlot && (slot = (SpecialSlot)patt4971$temp).m_7993_().m_150930_(slot.matchingItem);
            });
            if (!shouldGrant || !((livingEntity = this.tbAnimal.m_269323_()) instanceof ServerPlayer)) continue;
            ServerPlayer sp = (ServerPlayer)livingEntity;
            TBAdvancementRegistry.grantAdvancement(sp, advancement);
        }
    }

    protected void toggleChestSlots(boolean b) {
        for (int i = this.f_38839_.size() - 15 - 36; i < this.f_38839_.size(); ++i) {
            Object object = this.f_38839_.get(i);
            if (!(object instanceof ToggeableSlot)) continue;
            ToggeableSlot slot = (ToggeableSlot)((Object)object);
            slot.toggle(b);
        }
        this.hadChest = b;
    }

    public int addSpecialSlot(Pair<Integer, Integer> slotPos, Pair<Integer, Integer> slotType, SoundEvent soundEvent, Item matchingItem) {
        if (slotType == CHEST_SLOT_TEXTURE) {
            this.chestSlot = this.f_38839_.size();
        }
        this.specialSlots.add((Pair<Pair<Integer, Integer>, Pair<Integer, Integer>>)new Pair(slotPos, slotType));
        this.tbAnimal.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(inventory -> this.m_38897_((Slot)new SpecialSlot((IItemHandler)inventory, this.f_38839_.size(), (Integer)slotPos.getA() + 1, (Integer)slotPos.getB() + 1, this.tbAnimal, soundEvent, matchingItem)));
        return this.f_38839_.size() - 1;
    }

    private void createPlayerHotBar(Inventory playerInventory) {
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)playerInventory, column, 8 + column * 18, 142));
        }
    }

    private void createPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new Slot((Container)playerInventory, 9 + column + row * 9, 8 + column * 18, 84 + row * 18));
            }
        }
    }

    public TBAnimal getMob() {
        return this.tbAnimal;
    }

    private void dropChestContents() {
        for (int i = this.f_38839_.size() - 15 - 36; i < this.f_38839_.size(); ++i) {
            Object object = this.f_38839_.get(i);
            if (!(object instanceof ToggeableSlot)) continue;
            ToggeableSlot slot = (ToggeableSlot)((Object)object);
            ItemEntity itemEntity = new ItemEntity(this.tbAnimal.m_9236_(), this.tbAnimal.m_20185_(), this.tbAnimal.m_20186_(), this.tbAnimal.m_20189_(), slot.m_6201_(slot.m_7993_().m_41613_()));
            this.tbAnimal.m_9236_().m_7967_((Entity)itemEntity);
        }
    }

    protected boolean m_38903_(@NotNull ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean toReturn = super.m_38903_(p_38904_, p_38905_, p_38906_, p_38907_);
        this.checkAdvancementsAndChests();
        return toReturn;
    }

    public void m_150399_(int p_150400_, int p_150401_, @NotNull ClickType p_150402_, @NotNull Player p_150403_) {
        super.m_150399_(p_150400_, p_150401_, p_150402_, p_150403_);
        this.checkAdvancementsAndChests();
    }

    public boolean m_6875_(@NotNull Player playerIn) {
        return this.tbAnimal.m_6084_();
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player player, int index) {
        boolean moved;
        SpecialSlot s;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot == null || !slot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack copy = stack.m_41777_();
        SpecialSlot special = slot instanceof SpecialSlot ? (s = (SpecialSlot)slot) : null;
        boolean wasSpecialMatch = special != null && stack.m_150930_(special.matchingItem);
        int containerEnd = this.f_38839_.size() - 36;
        int invEnd = containerEnd + 27;
        int hotEnd = invEnd + 9;
        if (index < containerEnd) {
            moved = this.m_38903_(stack, containerEnd, invEnd, false) || this.m_38903_(stack, invEnd, hotEnd, false);
        } else if (index < invEnd) {
            moved = this.m_38903_(stack, 0, containerEnd, false) || this.m_38903_(stack, invEnd, hotEnd, false);
        } else {
            boolean bl = moved = this.m_38903_(stack, 0, containerEnd, false) || this.m_38903_(stack, containerEnd, invEnd, false);
        }
        if (!moved) {
            return ItemStack.f_41583_;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(ItemStack.f_41583_);
        } else {
            slot.m_6654_();
        }
        slot.m_142406_(player, stack);
        if (wasSpecialMatch && stack.m_41619_()) {
            this.tbAnimal.m_216990_(special.soundEvent);
        }
        return copy;
    }
}

