/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.block;

import com.modderg.tameablebeasts.registry.TBBlockEntityRegistry;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.server.block.EggBlockEntity;
import com.modderg.tameablebeasts.server.entity.FurGolemEntity;
import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EggBlock<T extends TBAnimal>
extends BaseEntityBlock {
    private final String species;
    private final RegistryObject<EntityType<T>> babyType;
    private VoxelShape CUSTOM_SHAPE;

    public String getSpecies() {
        return this.species;
    }

    public EggBlock(BlockBehaviour.Properties p_49224_, String species, RegistryObject<EntityType<T>> babyType, double width, double height) {
        super(p_49224_);
        this.babyType = babyType;
        this.species = species;
        this.CUSTOM_SHAPE = Block.m_49796_((double)((16.0 - width) / 2.0), (double)0.0, (double)((16.0 - width) / 2.0), (double)((16.0 - width) / 2.0 + width), (double)height, (double)((16.0 - width) / 2.0 + width));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new EggBlockEntity<T>(p_153215_, p_153216_, this.species, this.babyType);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState p_153213_, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return EggBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TBBlockEntityRegistry.EGG_BLOCK_ENTITY.get()), (plevel, pos, state, entity) -> entity.tick(plevel, pos, state));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return this.CUSTOM_SHAPE;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState p_49849_, @Nullable LivingEntity player, ItemStack p_49851_) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof EggBlockEntity) {
            EggBlockEntity egg = (EggBlockEntity)blockEntity;
            if (player != null) {
                egg.setOwnerUUID(player.m_20148_().toString());
            }
        }
        super.m_6402_(level, pos, p_49849_, player, p_49851_);
    }

    public void m_6240_(Level level, @NotNull Player p_49828_, BlockPos pos, @NotNull BlockState p_49830_, @Nullable BlockEntity p_49831_, @NotNull ItemStack p_49832_) {
        level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)TBItemRegistry.EGG_RESTS.get())));
        super.m_6240_(level, p_49828_, pos, p_49830_, p_49831_, p_49832_);
    }

    public void m_142072_(@NotNull Level level, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull Entity entity, float p_154849_) {
        if (this.canDestroyEgg(level, entity) && !level.f_46443_ && level.f_46441_.m_188503_(3) == 0 && state.m_60713_((Block)this)) {
            level.m_5594_(null, pos, SoundEvents.f_12533_, SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
            level.m_46961_(pos, false);
        }
        super.m_142072_(level, state, pos, entity, p_154849_);
    }

    private boolean canDestroyEgg(Level p_57768_, Entity p_57769_) {
        if (!(p_57769_ instanceof FurGolemEntity) && !(p_57769_ instanceof TBAnimal)) {
            if (!(p_57769_ instanceof LivingEntity)) {
                return false;
            }
            return p_57769_ instanceof Player || ForgeEventFactory.getMobGriefingEvent((Level)p_57768_, (Entity)p_57769_);
        }
        return false;
    }
}

