/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.block;

import com.modderg.tameablebeasts.registry.TBBlockEntityRegistry;
import com.modderg.tameablebeasts.server.block.EggBlock;
import com.modderg.tameablebeasts.server.config.ModCommonConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib.animatable.GeoBlockEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;

public class EggBlockEntity<T extends TBAnimal>
extends BlockEntity
implements GeoBlockEntity {
    public int goBadTimer = 20 * (Integer)ModCommonConfigs.GO_BAD_TIMER.get();
    public int hatchTimer = 20 * (Integer)ModCommonConfigs.HATCH_TIMER.get();
    public int textureID = 0;
    private String ownerUUID = "";
    private RegistryObject<EntityType<T>> babyType;
    private final String species;
    private AnimatableInstanceCache factory = new SingletonAnimatableInstanceCache((GeoAnimatable)this);

    public UUID getOwnerUUID() {
        if (this.ownerUUID.isEmpty()) {
            return UUID.randomUUID();
        }
        return UUID.fromString(this.ownerUUID);
    }

    public void setOwnerUUID(String value) {
        this.ownerUUID = value;
        this.m_6596_();
    }

    public String getCleanSpecies() {
        return this.getSpecies().replace("tameable_", "").replace("giant_", "");
    }

    public String getSpecies() {
        return this.species;
    }

    public void setTextureId(int id) {
        this.textureID = id;
    }

    public boolean isWarm() {
        int blockLight = Objects.requireNonNull(this.m_58904_()).m_5518_().m_75814_(LightLayer.BLOCK).m_7768_(this.m_58899_());
        return blockLight > 11;
    }

    public EggBlockEntity(BlockPos p_155229_, BlockState block) {
        super((BlockEntityType)TBBlockEntityRegistry.EGG_BLOCK_ENTITY.get(), p_155229_, block);
        this.species = ((EggBlock)block.m_60734_()).getSpecies();
    }

    public EggBlockEntity(BlockPos p_155229_, BlockState p_155230_, String species, RegistryObject<EntityType<T>> babyType) {
        super((BlockEntityType)TBBlockEntityRegistry.EGG_BLOCK_ENTITY.get(), p_155229_, p_155230_);
        this.babyType = babyType;
        this.species = species;
    }

    protected void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128359_("ownerUUID", this.ownerUUID);
        compound.m_128405_("hatchTimer", this.hatchTimer);
        compound.m_128405_("textureID", this.textureID);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.textureID = compound.m_128451_("textureID");
        this.hatchTimer = compound.m_128451_("hatchTimer");
        this.ownerUUID = compound.m_128461_("ownerUUID");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = this.m_187482_();
        tag.m_128405_("hatchTimer", this.hatchTimer);
        tag.m_128405_("textureID", this.textureID);
        tag.m_128359_("ownerUUID", this.ownerUUID);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
        this.hatchTimer = tag.m_128451_("hatchTimer");
        this.textureID = tag.m_128451_("textureID");
        this.ownerUUID = tag.m_128461_("ownerUUID");
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (!level.f_46443_) {
            if (this.goBadTimer-- >= 0 && this.isWarm()) {
                this.goBadTimer = 3000;
            }
            if (this.hatchTimer-- <= 0 && this.babyType != null) {
                TBAnimal animal = (TBAnimal)((EntityType)this.babyType.get()).m_20615_(level);
                animal.m_146884_(this.m_58899_().m_252807_());
                animal.m_6863_(true);
                animal.m_7105_(true);
                animal.setTextureId(this.textureID);
                animal.m_21816_(this.getOwnerUUID());
                animal.updateAttributes();
                animal.m_216990_(SoundEvents.f_12535_);
                level.m_7967_((Entity)animal);
                level.m_46961_(this.m_58899_(), false);
                this.m_7651_();
            }
            this.m_6596_();
            level.m_7260_(pos, state, state, 3);
        }
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        CompoundTag tag = packet.m_131708_();
        if (tag != null) {
            this.handleUpdateTag(tag);
            BlockState state = this.f_58857_.m_8055_(this.f_58858_);
            this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }
}

