/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.config;

import net.minecraftforge.common.ForgeConfigSpec;

public enum TBMobConfigs {
    ARGENTAVIS("Argentavis", 15.0),
    CHIKOTE("Chikote", 15.0),
    CRESTED_GECKO("Crested Gecko", 10.0),
    GRAPTERA("Grapteranodon", 20.0),
    GRASSHOPPER("Grasshopper", 20.0),
    SHINY_BEETLE("Flying Beetle", 10.0),
    GROUND_BEETLE("Ground Beetle", 15.0),
    METAL_GROUND_BEETLE("Metal Ground Beetle", 15.0),
    PENGUIN("Penguin", 15.0),
    QUETZAL("QuetzalCoatulus", 30.0),
    RACOON("Racoon", 25.0),
    ROLY_POLY("Roly Poly", 20.0);

    private final String displayName;
    private final Double defExtraTameHp;
    private ForgeConfigSpec.ConfigValue<Boolean> canSpawn;
    private ForgeConfigSpec.ConfigValue<Double> extraTameHp;

    private TBMobConfigs(String displayName, Double extraTameHp) {
        this.displayName = displayName;
        this.defExtraTameHp = extraTameHp;
    }

    public boolean canSpawnConfig() {
        return (Boolean)this.canSpawn.get();
    }

    public double extraTameHP() {
        return (Double)this.extraTameHp.get();
    }

    public static void registerCommonMobsConfigs(ForgeConfigSpec.Builder builder) {
        for (TBMobConfigs mob : TBMobConfigs.values()) {
            mob.canSpawn = builder.comment("Spawn " + mob.displayName).define(mob.displayName.replaceAll("\\s+", "") + " natural spawning enabled:", true);
        }
        for (TBMobConfigs mob : TBMobConfigs.values()) {
            mob.extraTameHp = builder.comment("Extra HP for tamed " + mob.displayName).define(mob.displayName.replaceAll("\\s+", "") + " added HP when tamed:", (Object)mob.defExtraTameHp);
        }
    }
}

