/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.CustomJumpMeter;
import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.client.gui.TBItemStackHandler;
import com.modderg.tameablebeasts.client.gui.TBMenu;
import com.modderg.tameablebeasts.client.gui.TBMenuJustSaddle;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPOITypesRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.ModCommonConfigs;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.FlyingRideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.NoFlyRandomStrollGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBWaterAvoidRandomFlyingGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.util.ClientUtils;

public class ArgentavisEntity
extends FlyingRideableTBAnimal
implements CustomJumpMeter {
    public ArgentavisEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.attackAnims.add("attack");
        this.consumeStaminaModule = 2;
        this.recoverStaminaModule = 10;
        this.downMovementAngle = 5.0f;
        this.inventory = new TBItemStackHandler(this, 1);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 30.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.25).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 48.0).m_22266_(Attributes.f_22288_);
    }

    @Override
    public void updateAttributes() {
        double maxHealth = 35.0;
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.ARGENTAVIS.extraTameHP();
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (!this.m_21824_() && this.isTameFood(itemstack)) {
            this.tameTBAnimal(player, itemstack, 33);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Item[] getBrushDrops() {
        return new Item[]{Items.f_42402_};
    }

    public static boolean checkArgentavisSpawnRules(EntityType<ArgentavisEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos blockpos, RandomSource p_218246_) {
        return ArgentavisEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)blockpos, (RandomSource)p_218246_) && TBMobConfigs.ARGENTAVIS.canSpawnConfig() && blockpos.m_123342_() >= (Integer)ModCommonConfigs.ARGENTAVIS_SPAWN_HEIGHT.get();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new SitWhenOrderedToGoal((TamableAnimal)this), new TakeCareOfEggsGoal((Animal)this, 15, TBPOITypesRegistry.ARGENTAVIS_POI), new TameablePanicGoal((PathfinderMob)this, 1.25), new NoFlyRandomStrollGoal(this, 1.0), new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(TBTagRegistry.Items.ARGENTAVIS_FOOD), false), new TBFollowParentGoal(this, 1.0), new BreedGoal((Animal)this, 1.0), new TBWaterAvoidRandomFlyingGoal(this, 1.0, 100), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new FloatGoal((Mob)this), new RandomLookAroundGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]), new OwnerHurtTargetGoal((TamableAnimal)this), new OwnerHurtByTargetGoal((TamableAnimal)this)});
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.ARGENTAVIS_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return this.m_21223_() < 10.0f && itemStack.m_204117_(TBTagRegistry.Items.ARGENTAVIS_TAME_FOOD);
    }

    @Override
    public float getRidingSpeedMultiplier() {
        if (this.m_20069_()) {
            return 0.6f;
        }
        if (this.m_20184_().f_82480_ < 0.0) {
            return 1.5f;
        }
        return 1.0f;
    }

    public void m_6863_(boolean p_146756_) {
        this.m_146762_(p_146756_ ? -48000 : 0);
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.ARGENTAVIS_EGG_ITEM.get());
    }

    @Override
    public ResourceLocation getStaminaSpriteLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/argentavis_stamina.png");
    }

    @Override
    public ResourceLocation getStaminaBackgroundLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/argentavis_stamina_back.png");
    }

    @Override
    public Vec2 getStaminaSpriteDimensions() {
        return new Vec2(47.0f, 30.0f);
    }

    @Override
    public float getStaminaHeight() {
        float f = this.flyingStamina;
        Objects.requireNonNull(this);
        return f / 50.0f;
    }

    @Override
    protected TBMenu createMenu(int containerId, Inventory playerInventory) {
        return new TBMenuJustSaddle(containerId, playerInventory, (Entity)this);
    }

    @Override
    public boolean hasSaddle() {
        return !this.m_6162_() && this.inventory.getStackInSlot(0).m_150930_(Items.f_42450_);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)TBSoundRegistry.ARGENTAVIS_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TBSoundRegistry.ARGENTAVIS_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)TBSoundRegistry.ARGENTAVIS_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)TBSoundRegistry.QUETZAL_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)TBSoundRegistry.ARGENTAVIS_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)TBSoundRegistry.ARGENTAVIS_INTERACT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(TBAnimControllers.flyGliderController(this)).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
            if (player != null) {
                player.m_5496_((SoundEvent)TBSoundRegistry.QUETZAL_FLY.get(), 0.75f, 0.75f);
            }
        })});
    }
}

