/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.client.gui.TBItemStackHandler;
import com.modderg.tameablebeasts.client.gui.TBMenu;
import com.modderg.tameablebeasts.client.gui.TBMenuJustSaddle;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPOITypesRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.ScarecrowAllayEntity;
import com.modderg.tameablebeasts.server.entity.abstracts.RideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.RaidCropsTameableGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class ChikoteEntity
extends RideableTBAnimal {
    public ChikoteEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.inventory = new TBItemStackHandler(this, 4);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public void updateAttributes() {
        double movSpeed = 0.3;
        if (this.m_6162_()) {
            movSpeed = 0.2;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(movSpeed);
        double maxHealth = 25.0;
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.CHIKOTE.extraTameHP();
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
    }

    public static boolean checkChikoteSpawnRules(EntityType<ChikoteEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return ChikoteEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)p_218245_, (RandomSource)p_218246_) && TBMobConfigs.CHIKOTE.canSpawnConfig();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new TameablePanicGoal((PathfinderMob)this, 1.2), new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f), new FloatGoal((Mob)this), new RaidCropsTameableGoal(this, 15), new SitWhenOrderedToGoal((TamableAnimal)this), new TakeCareOfEggsGoal((Animal)this, 15, TBPOITypesRegistry.CHIKOTE_POI), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTagRegistry.Items.CHIKOTE_FOOD), false), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new AvoidEntityGoal((PathfinderMob)this, ScarecrowAllayEntity.class, 8.0f, 2.2, 2.2), new RandomSwimmingGoal((PathfinderMob)this, 1.0, 10), new BreedGoal((Animal)this, 1.0), new TBFollowParentGoal(this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new RandomStrollGoal((PathfinderMob)this, 1.0, 10), new RandomLookAroundGoal((Mob)this)});
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 10);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Item[] getBrushDrops() {
        return new Item[]{Items.f_42402_};
    }

    @Override
    public float getRidingSpeedMultiplier() {
        return 1.2f;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.CHIKOTE_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.CHIKOTE_TAME_FOOD);
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.CHIKOTE_EGG_ITEM.get());
    }

    @Override
    protected TBMenu createMenu(int containerId, Inventory playerInventory) {
        return new TBMenuJustSaddle(containerId, playerInventory, (Entity)this);
    }

    @Override
    public boolean hasSaddle() {
        return !this.m_6162_() && this.inventory.getStackInSlot(0).m_150930_(Items.f_42450_);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        Vec3 vec3 = this.m_20184_();
        if (!this.m_20096_() && vec3.f_82480_ < 0.0) {
            this.m_20256_(vec3.m_82542_(1.0, 0.8, 1.0));
        }
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        return false;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)TBSoundRegistry.CHIKOTE_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TBSoundRegistry.CHIKOTE_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)TBSoundRegistry.CHIKOTE_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)TBSoundRegistry.CHIKOTE_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)TBSoundRegistry.CHIKOTE_HAPPY.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)TBSoundRegistry.CHIKOTE_INTERACT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(ChikoteEntity.chikoteAnimController(this)).triggerableAnim("eat_crop", RawAnimation.begin().then("eat_crop", Animation.LoopType.PLAY_ONCE))});
    }

    public static AnimationController<ChikoteEntity> chikoteAnimController(ChikoteEntity entity) {
        return new AnimationController((GeoAnimatable)entity, "movement", 5, event -> {
            if (!entity.m_20096_() && entity.m_20184_().f_82480_ < 0.0) {
                event.getController().setAnimation(RawAnimation.begin().then("riding_up", Animation.LoopType.LOOP));
                return PlayState.CONTINUE;
            }
            if (entity.m_6109_()) {
                if (event.isMoving()) {
                    event.getController().setAnimation(RawAnimation.begin().then("riding_walk", Animation.LoopType.LOOP));
                } else {
                    event.getController().setAnimation(RawAnimation.begin().then("idle_riding", Animation.LoopType.LOOP));
                }
                return PlayState.CONTINUE;
            }
            return TBAnimControllers.groundState(entity, event);
        });
    }
}

