/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.client.gui.TBItemStackHandler;
import com.modderg.tameablebeasts.client.gui.TBMenu;
import com.modderg.tameablebeasts.client.gui.TBMenuJustSaddle;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.RideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.entity.navigation.TBWallClimberNavigation;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class CrestedGeckoEntity
extends RideableTBAnimal {
    public CrestedGeckoEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.inventory = new TBItemStackHandler(this, 1);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.3);
    }

    @Override
    public void updateAttributes() {
        double maxHealth = 25.0;
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.CRESTED_GECKO.extraTameHP();
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new SitWhenOrderedToGoal((TamableAnimal)this), new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f), new FloatGoal((Mob)this), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTagRegistry.Items.CRESTED_GECKO_FOOD), false), new TameablePanicGoal((PathfinderMob)this, 1.5), new BreedGoal((Animal)this, 1.0), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new TBFollowParentGoal(this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new RandomLookAroundGoal((Mob)this)});
    }

    @Override
    public float getRidingSpeedMultiplier() {
        return 0.7f;
    }

    @Override
    @NotNull
    public PathNavigation m_6037_(@NotNull Level level) {
        return new TBWallClimberNavigation(this, level);
    }

    public static boolean checkCrestedGeckoSpawnRules(EntityType<CrestedGeckoEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return CrestedGeckoEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)p_218245_, (RandomSource)p_218246_) && TBMobConfigs.CRESTED_GECKO.canSpawnConfig();
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 20);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.CRESTED_GECKO_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.CRESTED_GECKO_TAME_FOOD);
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.CRESTED_GECKO_EGG_ITEM.get());
    }

    public boolean m_142535_(float p_147187_, float p_147188_, @NotNull DamageSource p_147189_) {
        if (!this.m_21824_()) {
            return super.m_142535_(p_147187_, p_147188_, p_147189_);
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.setClimbing(this.f_19862_);
        }
    }

    public boolean m_6147_() {
        return !this.m_21827_() && ((Byte)this.f_19804_.m_135370_(f_21798_) & 0x80) != 0 || this.m_6109_() && this.f_19862_;
    }

    public void setClimbing(boolean climbing) {
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        b0 = climbing ? (byte)(b0 | 0xFFFFFF80) : (byte)(b0 & 0x7F);
        this.f_19804_.m_135381_(f_21798_, (Object)b0);
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose p_19975_) {
        if (this.m_6147_()) {
            return new EntityDimensions(0.9f, 1.6f, true);
        }
        return this.m_6095_().m_20680_();
    }

    protected void m_19956_(@NotNull Entity rider, @NotNull Entity.MoveFunction moveFunction) {
        if (this.m_20363_(rider)) {
            if (this.m_6147_()) {
                this.positionWithOffSets(rider, moveFunction, -0.5f, 0.0f, 0.0f);
            } else {
                this.positionWithOffSets(rider, moveFunction, 0.5f, 0.0f, 0.0f);
            }
        }
    }

    public void positionWithOffSets(Entity rider, Entity.MoveFunction moveF, float xOffset, float zOffset, float yOffset) {
        double offsetX = Math.sin((double)this.m_146908_() * (Math.PI / 180)) * (double)xOffset;
        double offsetZ = Math.cos((double)this.m_146908_() * (Math.PI / 180)) * (double)(-xOffset);
        double offsetX2 = Math.cos((double)this.m_146908_() * (Math.PI / 180)) * (double)zOffset;
        double offsetZ2 = Math.sin((double)this.m_146908_() * (Math.PI / 180)) * (double)zOffset;
        double d0 = this.m_20186_() + this.m_6048_() + rider.m_6049_();
        moveF.m_20372_(rider, this.m_20185_() + offsetX + offsetX2, d0 + (double)yOffset, this.m_20189_() + offsetZ + offsetZ2);
    }

    @NotNull
    public Vec3 m_21074_(@NotNull Vec3 p_21075_, float p_21076_) {
        this.m_19920_(this.m_21330_(p_21076_), p_21075_);
        this.m_20256_(this.m_21297_(this.m_20184_()));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 vec3 = this.m_20184_();
        if ((this.f_19862_ || this.f_20899_) && (this.m_6147_() || this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_((Entity)this))) {
            vec3 = new Vec3(vec3.f_82479_, 0.2, vec3.f_82481_);
        }
        return vec3;
    }

    protected float m_21330_(float p_21331_) {
        return this.m_20096_() ? this.m_6113_() * (0.21600002f / (p_21331_ * p_21331_ * p_21331_)) : this.m_274460_();
    }

    protected Vec3 m_21297_(Vec3 p_21298_) {
        if (this.m_6147_()) {
            this.m_183634_();
            float f = 0.45f;
            double d0 = Mth.m_14008_((double)p_21298_.f_82479_, (double)(-f), (double)f);
            double d1 = Mth.m_14008_((double)p_21298_.f_82481_, (double)(-f), (double)f);
            double d2 = Math.max(p_21298_.f_82480_, (double)(-f));
            if (d2 < 0.0 && !this.m_146900_().isScaffolding((LivingEntity)this) && this.m_5791_()) {
                d2 = 0.0;
            }
            p_21298_ = new Vec3(d0, d2, d1);
        }
        return p_21298_;
    }

    @Override
    protected TBMenu createMenu(int containerId, Inventory playerInventory) {
        return new TBMenuJustSaddle(containerId, playerInventory, (Entity)this);
    }

    @Override
    public boolean hasSaddle() {
        return !this.m_6162_() && this.inventory.getStackInSlot(0).m_150930_(Items.f_42450_);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)TBSoundRegistry.CRESTED_GECKO_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TBSoundRegistry.CRESTED_GECKO_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)TBSoundRegistry.CRESTED_GECKO_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)TBSoundRegistry.CHIKOTE_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)TBSoundRegistry.CRESTED_GECKO_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)TBSoundRegistry.CRESTED_GECKO_INTERACT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(TBAnimControllers.groundController(this))});
    }
}

