/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.registry.TBAdvancementRegistry;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPOITypesRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.ModCommonConfigs;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class GroundBeetleEntity
extends TBAnimal
implements GeoEntity,
NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(GroundBeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> BEETLE_ID = SynchedEntityData.m_135353_(GroundBeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> IRON_CONSUMED = SynchedEntityData.m_135353_(GroundBeetleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    @javax.annotation.Nullable
    private UUID persistentAngerTarget;
    public boolean playBite = false;

    public GroundBeetleEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.attackAnims.add("attack");
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 6.0).m_22268_(Attributes.f_22284_, 15.0);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
        this.f_19804_.m_135372_(BEETLE_ID, (Object)0);
        this.f_19804_.m_135372_(IRON_CONSUMED, (Object)0);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("BEETLE_ID")) {
            this.setBeetleId(compound.m_128451_("BEETLE_ID"));
        }
        if (compound.m_128441_("IRON_CONSUMED")) {
            this.setConsumedIron(compound.m_128451_("IRON_CONSUMED"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BEETLE_ID", this.getBeetleID());
        compound.m_128405_("IRON_CONSUMED", this.getConsumedIron());
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 20);
            return InteractionResult.SUCCESS;
        }
        if (itemstack.isRepairable() && this.getHappiness() >= 50) {
            itemstack.m_41721_(itemstack.m_41773_() - 100);
            this.setHappiness(0);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    public void setBeetleId(int i) {
        this.m_20088_().m_135381_(BEETLE_ID, (Object)i);
    }

    public int getBeetleID() {
        return (Integer)this.m_20088_().m_135370_(BEETLE_ID);
    }

    public void setConsumedIron(int i) {
        this.m_20088_().m_135381_(IRON_CONSUMED, (Object)i);
    }

    public int getConsumedIron() {
        return (Integer)this.m_20088_().m_135370_(IRON_CONSUMED);
    }

    public boolean isMetallic() {
        return this.getConsumedIron() > (Integer)ModCommonConfigs.MIN_IRON_TRANSFORMS_GROUND_BEETLE.get();
    }

    public static boolean checkGroundBeetleSpawnRules(EntityType<GroundBeetleEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return TBMobConfigs.GROUND_BEETLE.canSpawnConfig();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f), new FleeSunGoal((PathfinderMob)this, 3.0), new TakeCareOfEggsGoal((Animal)this, 15, TBPOITypesRegistry.GROUND_BEETLE_POI), new FloatGoal((Mob)this), new LeapAtTargetGoal((Mob)this, 0.4f), new SitWhenOrderedToGoal((TamableAnimal)this), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTagRegistry.Items.GROUND_BEETLE_FOOD), false), new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new BreedGoal((Animal)this, 1.0), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new RandomLookAroundGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new OwnerHurtByTargetGoal((TamableAnimal)this), new HurtByTargetGoal((PathfinderMob)this, new Class[0]), new OwnerHurtTargetGoal((TamableAnimal)this)});
    }

    @Override
    public Item[] getBrushDrops() {
        return new Item[]{(Item)TBItemRegistry.BEETLE_ARMOR_PIECE.get(), this.isMetallic() ? Items.f_151050_ : (Item)TBItemRegistry.BEETLE_ARMOR_PIECE.get()};
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        boolean isFood = itemStack.m_204117_(TBTagRegistry.Items.GROUND_BEETLE_FOOD);
        if (isFood) {
            this.playBite = true;
        }
        return isFood;
    }

    public boolean m_6898_(ItemStack p_27600_) {
        boolean isFood = p_27600_.m_204117_(TBTagRegistry.Items.GROUND_BEETLE_TAME_FOOD);
        boolean isMetalFood = p_27600_.m_204117_(TBTagRegistry.Items.GROUND_BEETLE_METAL_FOOD);
        if (!this.m_6162_() && isMetalFood) {
            LivingEntity livingEntity;
            boolean wasMetal = this.isMetallic();
            this.setConsumedIron(this.getConsumedIron() + 1);
            if (!wasMetal && this.isMetallic()) {
                this.handleEffects(true);
            }
            if (this.isMetallic() && (livingEntity = this.m_269323_()) instanceof ServerPlayer) {
                ServerPlayer sv = (ServerPlayer)livingEntity;
                TBAdvancementRegistry.grantAdvancement(sv, TBAdvancementRegistry.METAL_BEETLE);
            }
        }
        if (isFood) {
            this.playBite = true;
        }
        return isFood || isMetalFood;
    }

    @Override
    public AgeableMob m_142606_(@NotNull ServerLevel p_146743_, @NotNull AgeableMob parent) {
        return null;
    }

    @Override
    public void updateAttributes() {
        double movSpeed = 0.3;
        double maxHealth = 15.0;
        double armor = 15.0;
        double knockResist = 0.0;
        if (this.m_6162_()) {
            movSpeed = 0.1;
        }
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.GROUND_BEETLE.extraTameHP();
        }
        if (this.isMetallic()) {
            armor = 30.0;
            knockResist = 0.8;
            maxHealth += TBMobConfigs.METAL_GROUND_BEETLE.extraTameHP();
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(movSpeed);
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
        this.m_21051_(Attributes.f_22284_).m_22100_(armor);
        this.m_21051_(Attributes.f_22278_).m_22100_(knockResist);
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.GROUND_BEETLE_EGG_ITEM.get());
    }

    @Override
    public boolean m_7327_(@NotNull Entity target) {
        boolean ret = super.m_7327_(target);
        if (!this.isMetallic() && !(target instanceof LivingEntity)) {
            return ret;
        }
        LivingEntity livingTarget = (LivingEntity)target;
        if (this.getBeetleID() == 1) {
            Vec3 currMotion = target.m_20184_();
            Vec3 newMotion = new Vec3(currMotion.f_82479_, 1.0 - Objects.requireNonNull(livingTarget.m_21051_(Attributes.f_22278_)).m_22115_(), currMotion.f_82481_);
            target.m_20256_(newMotion);
            return ret;
        }
        double dx = this.m_20185_() - target.m_20185_();
        double dz = this.m_20189_() - target.m_20189_();
        livingTarget.m_147240_(1.5, dx, dz);
        return ret;
    }

    @Override
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance p_146747_, @NotNull MobSpawnType p_146748_, @Nullable SpawnGroupData p_146749_, @Nullable CompoundTag p_146750_) {
        this.setBeetleId(this.m_217043_().m_188503_(2));
        return super.m_6518_(levelAccessor, p_146747_, p_146748_, p_146749_, p_146750_);
    }

    public void handleEffects(boolean transformed) {
        this.m_216990_(transformed ? SoundEvents.f_12009_ : SoundEvents.f_12494_);
        for (int i = 0; i < 5; ++i) {
            double offsetX = (this.m_217043_().m_188500_() * 3.0 - 0.25) * (double)this.m_20205_();
            double offsetY = this.m_217043_().m_188500_() * 3.0 * (double)this.m_20206_();
            double offsetZ = (this.m_217043_().m_188500_() * 3.0 - 0.25) * (double)this.m_20205_();
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123751_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + offsetX, this.m_20186_() + offsetY, this.m_20189_() + offsetZ, 0.0, 0.0, 0.0);
        }
    }

    public SoundEvent m_7515_() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.BEETLE_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.BEETLE_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.BEETLE_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)TBSoundRegistry.BEETLE_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.BEETLE_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.BEETLE_INTERACT.get();
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int p_30404_) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)p_30404_);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    @javax.annotation.Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@javax.annotation.Nullable UUID p_30400_) {
        this.persistentAngerTarget = p_30400_;
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(TBAnimControllers.groundController(this))});
        control.add(new AnimationController[]{this.biteController(this)});
    }

    public <T extends TBAnimal> AnimationController<T> biteController(T entity) {
        return new AnimationController(entity, "mouthController", 10, event -> {
            AnimationController controller = event.getController();
            if (this.playBite) {
                controller.setAnimation(RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE));
                this.playBite = false;
            }
            return PlayState.CONTINUE;
        });
    }
}

