/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.client.gui.TBItemStackHandler;
import com.modderg.tameablebeasts.client.gui.TBMenu;
import com.modderg.tameablebeasts.client.gui.TBMenuPenguin;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPOITypesRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.RideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.abstracts.TBSemiAquatic;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.RunFromNowAndThenGoal;
import com.modderg.tameablebeasts.server.entity.goals.SemiAquaticRandomStrollGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class PenguinEntity
extends RideableTBAnimal
implements GeoEntity,
TBSemiAquatic {
    TBFollowOwnerGoal followOwnerGoal;

    public PenguinEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.attackAnims.add("attack");
        this.attackAnims.add("sword_attack");
        this.attackAnims.add("sword_attack2");
        this.m_274367_(1.0f);
        this.inventory = new TBItemStackHandler(this, 4);
        if (!this.m_9236_().m_5776_()) {
            this.initPathAndMoveControls();
        }
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21644_;
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 2.5).m_22268_(Attributes.f_22284_, 2.0);
    }

    @Override
    public void updateAttributes() {
        double armor = 0.0;
        double movSpeed = 0.3;
        double maxHealth = 10.0;
        double attackDamage = 2.5;
        if (this.m_20069_()) {
            movSpeed = 2.5;
        }
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.PENGUIN.extraTameHP();
            attackDamage = 5.0 + 5.0 * (double)this.hasSword();
            if (this.getHelmet()) {
                armor += 8.0;
            }
            if (this.hasSaddle()) {
                armor += 12.0;
            }
        }
        this.m_21051_(Attributes.f_22284_).m_22100_(armor);
        this.m_21051_(Attributes.f_22279_).m_22100_(movSpeed);
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
        this.m_21051_(Attributes.f_22281_).m_22100_(attackDamage);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.followOwnerGoal = new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f, false, true);
        this.addGoals(new Goal[]{new SitWhenOrderedToGoal((TamableAnimal)this), new TameablePanicGoal((PathfinderMob)this, 1.2), this.followOwnerGoal, new BreedGoal((Animal)this, 1.0), new TakeCareOfEggsGoal((Animal)this, 15, TBPOITypesRegistry.PENGUIN_POI), new RunFromNowAndThenGoal(this), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTagRegistry.Items.PENGUIN_FOOD), false), new IncludesSitingRidingMeleeAttackGoal(this, 1.0, false), new TameablePanicGoal((PathfinderMob)this, 1.25), new SemiAquaticRandomStrollGoal(this, 1.0), new TBFollowParentGoal(this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new RandomLookAroundGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new OwnerHurtByTargetGoal((TamableAnimal)this), new OwnerHurtTargetGoal((TamableAnimal)this), new NonTameRandomTargetGoal((TamableAnimal)this, AbstractFish.class, false, null)});
    }

    public int hasSword() {
        return (!this.m_6162_() ? 1 : 0) * (Boolean.compare(this.inventory.getStackInSlot(2).m_150930_((Item)TBItemRegistry.ICEPOP.get()), false) + Boolean.compare(this.inventory.getStackInSlot(3).m_150930_((Item)TBItemRegistry.ICEPOP.get()), false));
    }

    public boolean getHelmet() {
        return !this.m_6162_() && this.inventory.getStackInSlot(0).m_150930_((Item)TBItemRegistry.ICE_HELMET.get());
    }

    @Override
    public boolean hasSaddle() {
        return !this.m_6162_() && this.inventory.getStackInSlot(1).m_150930_((Item)TBItemRegistry.ICE_CHESTPLATE.get());
    }

    @Override
    public TBFollowOwnerGoal getFollowOwnerGoal() {
        return this.followOwnerGoal;
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.PENGUIN_EGG_ITEM.get());
    }

    public static boolean isPenguinSpawneableBlock(BlockState blockState) {
        return blockState.m_60713_(Blocks.f_50568_) || blockState.m_60713_(Blocks.f_50126_) || blockState.m_60713_(Blocks.f_50568_) || blockState.m_60713_(Blocks.f_50354_) || blockState.m_60713_(Blocks.f_50449_);
    }

    public static boolean checkPenguinSpawnRules(EntityType<PenguinEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return PenguinEntity.isPenguinSpawneableBlock(p_218243_.m_8055_(p_218245_.m_7495_())) && PenguinEntity.m_186209_((BlockAndTintGetter)p_218243_, (BlockPos)p_218245_) && TBMobConfigs.PENGUIN.canSpawnConfig();
    }

    @Override
    protected TBMenu createMenu(int containerId, Inventory playerInventory) {
        return new TBMenuPenguin(containerId, playerInventory, (Entity)this);
    }

    public boolean m_20068_() {
        return this.m_20069_();
    }

    @Override
    public void m_8119_() {
        if (this.m_20069_() && !this.m_20197_().isEmpty()) {
            this.m_20153_();
        }
        if (!this.m_9236_().m_5776_() && this.m_20069_() != this.isAquatic()) {
            this.switchNavigation();
            this.updateAttributes();
        }
        super.m_8119_();
    }

    public boolean canDrownInFluidType(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.canDrownInFluidType(type);
    }

    public boolean isPushedByFluid(FluidType type) {
        if (type == ForgeMod.WATER_TYPE.get()) {
            return false;
        }
        return super.isPushedByFluid(type);
    }

    protected boolean m_6129_() {
        return false;
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 20);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Item[] getBrushDrops() {
        return new Item[]{Items.f_42402_};
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.PENGUIN_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.PENGUIN_TAME_FOOD);
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    public float getRidingSpeedMultiplier() {
        BlockState blockState = this.m_20075_();
        if (blockState.m_60713_(Blocks.f_50126_) || blockState.m_60713_(Blocks.f_50568_) || blockState.m_60713_(Blocks.f_50354_) || blockState.m_60713_(Blocks.f_50449_)) {
            return 2.0f;
        }
        return 0.1f;
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)TBSoundRegistry.PENGUIN_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TBSoundRegistry.PENGUIN_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)TBSoundRegistry.PENGUIN_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState blockState) {
        if (this.m_20160_() && (blockState.m_60713_(Blocks.f_50126_) || blockState.m_60713_(Blocks.f_50568_) || blockState.m_60713_(Blocks.f_50354_) || blockState.m_60713_(Blocks.f_50449_))) {
            this.m_5496_(SoundEvents.f_12494_, 0.15f, 1.0f);
        }
        this.m_5496_((SoundEvent)TBSoundRegistry.PENGUIN_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)TBSoundRegistry.PENGUIN_HAPPY.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)TBSoundRegistry.PENGUIN_INTERACT.get();
    }

    @Override
    public void playAttackAnim() {
        this.triggerAnim("movement", this.hasSword() < 1 ? "attack" : (String)this.attackAnims.get(this.f_19796_.m_188503_(this.attackAnims.size())));
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(this.penguinVehicleController(this))});
    }

    public <T extends RideableTBAnimal> AnimationController<T> penguinVehicleController(T entity) {
        return new AnimationController(entity, "movement", 3, event -> {
            if (entity.m_20069_()) {
                if (event.isMoving()) {
                    event.getController().setAnimation(RawAnimation.begin().then("swim", Animation.LoopType.LOOP));
                } else {
                    event.getController().setAnimation(RawAnimation.begin().then("sit", Animation.LoopType.LOOP));
                }
                return PlayState.CONTINUE;
            }
            return TBAnimControllers.vehicleState(entity, event);
        });
    }
}

