/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.CustomJumpMeter;
import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.client.gui.TBItemStackHandler;
import com.modderg.tameablebeasts.client.gui.TBMenu;
import com.modderg.tameablebeasts.client.gui.TBMenuQuetzal;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPOITypesRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.ModCommonConfigs;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.FlyingRideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.NoFlyRandomStrollGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBWaterAvoidRandomFlyingGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.Animation;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;

public class QuetzalcoatlusEntity
extends FlyingRideableTBAnimal
implements CustomJumpMeter {
    public boolean playBite = false;

    public QuetzalcoatlusEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.consumeStaminaModule = 14;
        this.recoverStaminaModule = 8;
        this.downMovementAngle = 8.0f;
        this.inventory = new TBItemStackHandler(this, 18);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22280_, 0.2).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 48.0).m_22266_(Attributes.f_22288_);
    }

    @Override
    public void updateAttributes() {
        double maxHealth = 40.0;
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.QUETZAL.extraTameHP();
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
    }

    public static boolean checkQuetzalSpawnRules(EntityType<QuetzalcoatlusEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos pos, RandomSource p_218246_) {
        return QuetzalcoatlusEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)pos, (RandomSource)p_218246_) && TBMobConfigs.QUETZAL.canSpawnConfig() && pos.m_123342_() > (Integer)ModCommonConfigs.QUETZAL_SPAWN_HEIGHT.get();
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new SitWhenOrderedToGoal((TamableAnimal)this), new TakeCareOfEggsGoal((Animal)this, 15, TBPOITypesRegistry.QUETZAL_POI), new TameablePanicGoal((PathfinderMob)this, 1.25), new NoFlyRandomStrollGoal(this, 1.0), new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(TBTagRegistry.Items.QUETZAL_FOOD), false), new TBFollowParentGoal(this, 1.0), new BreedGoal((Animal)this, 1.0), new TBWaterAvoidRandomFlyingGoal(this, 1.0, 200), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new FloatGoal((Mob)this), new RandomLookAroundGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new OwnerHurtByTargetGoal((TamableAnimal)this), new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true), new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]), new OwnerHurtTargetGoal((TamableAnimal)this)});
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 33);
            return InteractionResult.SUCCESS;
        }
        if (this.m_21824_() && this.hasStand() && !this.m_21830_((LivingEntity)player) && !this.m_21825_()) {
            player.m_20329_((Entity)this);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public boolean hatBoostItem(Player player) {
        return player.m_150109_().m_36052_(3).m_150930_((Item)TBItemRegistry.FLYING_HELMET.get());
    }

    public boolean m_6898_(ItemStack p_27600_) {
        boolean isFood = p_27600_.m_204117_(TBTagRegistry.Items.QUETZAL_FOOD);
        if (isFood) {
            this.playBite = true;
        }
        return isFood;
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        boolean isFood;
        boolean bl = isFood = this.m_21223_() < 10.0f && itemStack.m_204117_(TBTagRegistry.Items.QUETZAL_TAME_FOOD);
        if (isFood) {
            this.playBite = true;
        }
        return isFood;
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.QUETZAL_EGG_ITEM.get());
    }

    public void m_6863_(boolean p_146756_) {
        this.m_146762_(p_146756_ ? -48000 : 0);
    }

    protected void m_19956_(@NotNull Entity rider, @NotNull Entity.MoveFunction p_19958_) {
        if (((Entity)this.m_20197_().get(0)).equals((Object)rider)) {
            super.m_19956_(rider, p_19958_);
        } else if (((Entity)this.m_20197_().get(1)).equals((Object)rider)) {
            this.positionWithOffSets(rider, 0.9f, -0.7f, 1.1f, 0.9f);
        } else if (((Entity)this.m_20197_().get(2)).equals((Object)rider)) {
            this.positionWithOffSets(rider, 0.9f, 0.7f, 1.1f, 0.9f);
        } else {
            this.positionWithOffSets(rider, 0.6f, 0.0f, 1.0f, 0.9f);
        }
    }

    public void positionWithOffSets(Entity rider, float xOffset, float zOffset, float yMovingOffSet, float yStillOffSet) {
        double cos = Math.cos((double)this.m_146908_() * (Math.PI / 180));
        double sin = Math.sin((double)this.m_146908_() * (Math.PI / 180));
        double offsetX = sin * (double)xOffset;
        double offsetZ = cos * (double)(-xOffset);
        double offsetX2 = cos * (double)zOffset;
        double offsetZ2 = sin * (double)zOffset;
        rider.m_6034_(this.m_20185_() + offsetX + offsetX2, this.m_20186_() + rider.m_6049_() + (double)(this.isServerFlying() ? yMovingOffSet : yStillOffSet), this.m_20189_() + offsetZ + offsetZ2);
    }

    protected boolean m_7310_(@NotNull Entity entity) {
        return this.m_20197_().size() < 5 && this.hasStand() && !this.m_20197_().isEmpty() || this.m_21830_((LivingEntity)entity) && super.m_7310_(entity);
    }

    @Override
    public float getRidingSpeedMultiplier() {
        Player p;
        if (this.m_20069_()) {
            return 0.4f;
        }
        LivingEntity passenger = this.m_6688_();
        if (passenger instanceof Player && this.hatBoostItem(p = (Player)passenger)) {
            return 1.0f;
        }
        return 0.6f;
    }

    @Override
    protected TBMenu createMenu(int containerId, Inventory playerInventory) {
        return new TBMenuQuetzal(containerId, playerInventory, (Entity)this);
    }

    @Override
    public boolean hasSaddle() {
        return !this.m_6162_() && this.inventory.getStackInSlot(0).m_150930_(Items.f_42450_);
    }

    public boolean hasChest() {
        return !this.m_6162_() && this.inventory.getStackInSlot(2).m_150930_(Items.f_42009_);
    }

    public boolean hasStand() {
        return !this.m_6162_() && this.inventory.getStackInSlot(1).m_150930_((Item)TBItemRegistry.QUETZAL_STAND.get());
    }

    @Override
    public ResourceLocation getStaminaSpriteLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/quetzal_stamina.png");
    }

    @Override
    public ResourceLocation getStaminaBackgroundLocation() {
        return new ResourceLocation("tameablebeasts", "textures/gui/quetzal_stamina_back.png");
    }

    @Override
    public Vec2 getStaminaSpriteDimensions() {
        return new Vec2(53.0f, 40.0f);
    }

    @Override
    public float getStaminaHeight() {
        float f = this.flyingStamina;
        Objects.requireNonNull(this);
        return f / 50.0f;
    }

    public SoundEvent m_7515_() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.QUETZAL_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.QUETZAL_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.QUETZAL_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        this.m_5496_((SoundEvent)TBSoundRegistry.QUETZAL_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.QUETZAL_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        this.playBite = true;
        return (SoundEvent)TBSoundRegistry.QUETZAL_INTERACT.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(TBAnimControllers.flyGliderController(this)).setSoundKeyframeHandler(state -> {
            Player player = ClientUtils.getClientPlayer();
            if (player != null) {
                player.m_5496_((SoundEvent)TBSoundRegistry.QUETZAL_FLY.get(), 0.5f, 0.5f);
            }
        })});
        control.add(new AnimationController[]{this.biteController(this)});
    }

    public <T extends FlyingRideableTBAnimal> AnimationController<T> biteController(T entity) {
        return new AnimationController(entity, "mouthController", 10, event -> {
            AnimationController controller = event.getController();
            if (this.playBite) {
                controller.setAnimation(RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE));
                this.playBite = false;
                controller.forceAnimationReset();
            }
            return PlayState.CONTINUE;
        });
    }
}

