/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.TBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.IncludesSitingRidingMeleeAttackGoal;
import com.modderg.tameablebeasts.server.entity.goals.RacoonStealFoodGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class RacoonEntity
extends TBAnimal
implements GeoEntity {
    private static final Predicate<LivingEntity> AVOID_VICTIMS = p_28463_ -> !p_28463_.m_20163_() && EntitySelector.f_20406_.test(p_28463_);
    private static final EntityDataAccessor<Boolean> IS_BELLY_FULL = SynchedEntityData.m_135353_(RacoonEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int dropFurTime = this.m_217043_().m_216339_(300, 1000);

    public void setBellyFull(boolean i) {
        this.m_20088_().m_135381_(IS_BELLY_FULL, (Object)i);
    }

    public boolean isBellyFull() {
        return (Boolean)this.m_20088_().m_135370_(IS_BELLY_FULL);
    }

    public RacoonEntity(EntityType<? extends TBAnimal> p_27557_, Level p_27558_) {
        super(p_27557_, p_27558_);
        this.hasWarmthVariants();
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 8.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 6.0);
    }

    @Override
    public void updateAttributes() {
        double maxHealth = 10.0;
        double movSpeed = 0.3;
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.RACOON.extraTameHP();
        }
        if (this.isBellyFull()) {
            movSpeed = 0.2;
        }
        this.m_21051_(Attributes.f_22279_).m_22100_(movSpeed);
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
    }

    public static boolean checkRacoonSpawnRules(EntityType<RacoonEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return RacoonEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)p_218245_, (RandomSource)p_218246_) && TBMobConfigs.RACOON.canSpawnConfig();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f), new FloatGoal((Mob)this), new RacoonStealFoodGoal(this, 1.3), new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.6, 1.4, player -> this.isBellyFull() && !this.m_21824_() && AVOID_VICTIMS.test((LivingEntity)player)), new LeapAtTargetGoal((Mob)this, 0.4f), new TemptGoal((PathfinderMob)this, 1.1, Ingredient.m_204132_(TBTagRegistry.Items.RACOON_FOOD), false), new SitWhenOrderedToGoal((TamableAnimal)this), new BreedGoal((Animal)this, 1.0), new TBFollowParentGoal(this, 1.0), new TameablePanicGoal((PathfinderMob)this, 1.2), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new RandomLookAroundGoal((Mob)this)});
        this.addTargetGoals(new Goal[]{new OwnerHurtByTargetGoal((TamableAnimal)this), new OwnerHurtTargetGoal((TamableAnimal)this), new IncludesSitingRidingMeleeAttackGoal(this, 1.0, true)});
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BELLY_FULL, (Object)false);
    }

    @Override
    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("IS_BELLY_FULL")) {
            this.setBellyFull(compound.m_128471_("IS_BELLY_FULL"));
        }
    }

    @Override
    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IS_BELLY_FULL", this.isBellyFull());
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 15);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Item[] getBrushDrops() {
        return new Item[]{(Item)TBItemRegistry.FUR.get()};
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.RACOON_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.RACOON_TAME_FOOD);
    }

    public void m_8119_() {
        if (this.isBellyFull() && this.dropFurTime-- <= 0) {
            this.dropFurTime = this.m_217043_().m_216339_(300, 1500);
            this.m_19998_((ItemLike)TBItemRegistry.FUR.get());
            this.setBellyFull(false);
        }
        super.m_8119_();
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)TBSoundRegistry.RACOON_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TBSoundRegistry.RACOON_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return (SoundEvent)TBSoundRegistry.RACOON_HURT.get();
    }

    protected void m_7355_(BlockPos p_20135_, BlockState p_20136_) {
        this.m_5496_((SoundEvent)TBSoundRegistry.RACOON_STEPS.get(), 0.15f, 1.0f);
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)TBSoundRegistry.RACOON_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)TBSoundRegistry.RACOON_HAPPY.get();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(TBAnimControllers.groundController(this))});
    }
}

