/*
 * Decompiled with CFR 0.152.
 */
package com.modderg.tameablebeasts.server.entity;

import com.modderg.tameablebeasts.client.entity.TBAnimControllers;
import com.modderg.tameablebeasts.client.gui.TBItemStackHandler;
import com.modderg.tameablebeasts.client.gui.TBMenu;
import com.modderg.tameablebeasts.client.gui.TBMenuJustSaddle;
import com.modderg.tameablebeasts.registry.TBBlockRegistry;
import com.modderg.tameablebeasts.registry.TBItemRegistry;
import com.modderg.tameablebeasts.registry.TBPOITypesRegistry;
import com.modderg.tameablebeasts.registry.TBSoundRegistry;
import com.modderg.tameablebeasts.registry.TBTagRegistry;
import com.modderg.tameablebeasts.server.config.TBMobConfigs;
import com.modderg.tameablebeasts.server.entity.abstracts.RideableTBAnimal;
import com.modderg.tameablebeasts.server.entity.goals.RunFromNowAndThenGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowOwnerGoal;
import com.modderg.tameablebeasts.server.entity.goals.TBFollowParentGoal;
import com.modderg.tameablebeasts.server.entity.goals.TakeCareOfEggsGoal;
import com.modderg.tameablebeasts.server.entity.goals.TameablePanicGoal;
import com.modderg.tameablebeasts.server.item.block.EggBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;

public class RolyPolyEntity
extends RideableTBAnimal {
    public RolyPolyEntity(EntityType<? extends TamableAnimal> p_21803_, Level p_21804_) {
        super(p_21803_, p_21804_);
        this.hasWarmthVariants();
        this.inventory = new TBItemStackHandler(this, 1);
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.225).m_22268_(Attributes.f_22276_, 20.0);
    }

    @Override
    public void updateAttributes() {
        double movSpeed = 0.25;
        if (this.isRunning()) {
            movSpeed = 0.3;
        }
        double maxHealth = 20.0;
        if (this.m_21824_()) {
            maxHealth += TBMobConfigs.ROLY_POLY.extraTameHP();
        }
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
        this.m_21051_(Attributes.f_22279_).m_22100_(movSpeed);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public boolean hatBoostItem(Player player) {
        return player.m_150109_().m_36052_(3).m_150930_((Item)TBItemRegistry.BIKER_HELMET.get());
    }

    public static boolean checkRolyPolySpawnRules(EntityType<RolyPolyEntity> p_218242_, LevelAccessor p_218243_, MobSpawnType p_218244_, BlockPos p_218245_, RandomSource p_218246_) {
        return RolyPolyEntity.m_218104_(p_218242_, (LevelAccessor)p_218243_, (MobSpawnType)p_218244_, (BlockPos)p_218245_, (RandomSource)p_218246_) && TBMobConfigs.ROLY_POLY.canSpawnConfig();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.addGoals(new Goal[]{new TameablePanicGoal((PathfinderMob)this, 1.2), new TBFollowOwnerGoal(this, 1.0, 10.0f, 6.0f), new FloatGoal((Mob)this), new SitWhenOrderedToGoal((TamableAnimal)this), new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_204132_(TBTagRegistry.Items.ROLY_POLY_FOOD), false), new RunFromNowAndThenGoal(this), new TakeCareOfEggsGoal((Animal)this, 15, TBPOITypesRegistry.ROLY_POLY_POI), new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0), new BreedGoal((Animal)this, 1.0), new TBFollowParentGoal(this, 1.0), new LookAtPlayerGoal((Mob)this, Player.class, 6.0f)});
    }

    @Override
    @NotNull
    public InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isTameFood(itemstack) && !this.m_21824_()) {
            this.tameTBAnimal(player, itemstack, 20);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Item[] getBrushDrops() {
        return new Item[]{(Item)TBItemRegistry.ROLY_POLY_PLAQUE.get()};
    }

    public boolean m_6898_(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.ROLY_POLY_FOOD);
    }

    @Override
    public boolean isTameFood(ItemStack itemStack) {
        return itemStack.m_204117_(TBTagRegistry.Items.ROLY_POLY_TAME_FOOD);
    }

    @Override
    public EggBlockItem getEgg() {
        return (EggBlockItem)((Object)TBItemRegistry.ROLY_POLY_EGG_ITEM.get());
    }

    @Override
    public float getRidingSpeedMultiplier() {
        return super.getRidingSpeedMultiplier() * (this.m_20075_().m_60713_((Block)TBBlockRegistry.ASPHALTED_DIRT.get()) ? 1.75f : 1.0f);
    }

    @Override
    protected TBMenu createMenu(int containerId, Inventory playerInventory) {
        return new TBMenuJustSaddle(containerId, playerInventory, (Entity)this);
    }

    @Override
    public boolean hasSaddle() {
        return !this.m_6162_() && this.inventory.getStackInSlot(0).m_150930_(Items.f_42450_);
    }

    public SoundEvent m_7515_() {
        return (SoundEvent)TBSoundRegistry.ROLYPOLY_AMBIENT.get();
    }

    public SoundEvent m_5592_() {
        return (SoundEvent)TBSoundRegistry.ROLYPOLY_DEATH.get();
    }

    protected SoundEvent m_7975_(@NotNull DamageSource p_21239_) {
        return (SoundEvent)TBSoundRegistry.ROLYPOLY_HURT.get();
    }

    protected void m_7355_(@NotNull BlockPos p_20135_, @NotNull BlockState p_20136_) {
        if (this.isRunning()) {
            this.m_5496_((SoundEvent)TBSoundRegistry.ROLYPOLY_ROLL.get(), 0.15f, 1.0f);
        } else {
            this.m_5496_((SoundEvent)TBSoundRegistry.ROLYPOLY_STEPS.get(), 0.15f, 1.0f);
        }
    }

    @Override
    public SoundEvent getTameSound() {
        return (SoundEvent)TBSoundRegistry.ROLYPOLY_INTERACT.get();
    }

    @Override
    public SoundEvent getInteractSound() {
        return (SoundEvent)TBSoundRegistry.ROLYPOLY_INTERACT.get();
    }

    @Override
    public boolean isRunning() {
        return super.isRunning() || this.m_217005_();
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar control) {
        control.add(new AnimationController[]{this.addAnimationTriggers(TBAnimControllers.vehicleController(this))});
    }
}

